/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class EntityPositionSource
implements PositionSource {
    public static final Codec<EntityPositionSource> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)UUIDUtil.CODEC.fieldOf("source_entity").forGetter(EntityPositionSource::getUuid), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.yOffset))).apply((Applicative)var02, (var0, var1) -> new EntityPositionSource((Either<Entity, Either<UUID, Integer>>)Either.right((Object)Either.left((Object)var0)), var1.floatValue())));
    private Either<Entity, Either<UUID, Integer>> entityOrUuidOrId;
    final float yOffset;

    public EntityPositionSource(Entity var0, float var1) {
        this((Either<Entity, Either<UUID, Integer>>)Either.left((Object)var0), var1);
    }

    EntityPositionSource(Either<Entity, Either<UUID, Integer>> var0, float var1) {
        this.entityOrUuidOrId = var0;
        this.yOffset = var1;
    }

    @Override
    public Optional<Vec3D> getPosition(World var02) {
        if (this.entityOrUuidOrId.left().isEmpty()) {
            this.resolveEntity(var02);
        }
        return this.entityOrUuidOrId.left().map(var0 -> var0.position().add(0.0, this.yOffset, 0.0));
    }

    private void resolveEntity(World var02) {
        ((Optional)this.entityOrUuidOrId.map(Optional::of, var12 -> Optional.ofNullable((Entity)var12.map(var1 -> {
            Entity entity;
            if (var02 instanceof WorldServer) {
                WorldServer var2 = (WorldServer)var02;
                entity = var2.getEntity((UUID)var1);
            } else {
                entity = null;
            }
            return entity;
        }, var02::getEntity)))).ifPresent(var0 -> {
            this.entityOrUuidOrId = Either.left((Object)var0);
        });
    }

    private UUID getUuid() {
        return (UUID)this.entityOrUuidOrId.map(Entity::getUUID, var02 -> (UUID)var02.map(Function.identity(), var0 -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    int getId() {
        return (Integer)this.entityOrUuidOrId.map(Entity::getId, var02 -> (Integer)var02.map(var0 -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.ENTITY;
    }

    public static class a
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public EntityPositionSource read(PacketDataSerializer var0) {
            return new EntityPositionSource((Either<Entity, Either<UUID, Integer>>)Either.right((Object)Either.right((Object)var0.readVarInt())), var0.readFloat());
        }

        @Override
        public void write(PacketDataSerializer var0, EntityPositionSource var1) {
            var0.writeVarInt(var1.getId());
            var0.writeFloat(var1.yOffset);
        }

        @Override
        public Codec<EntityPositionSource> codec() {
            return CODEC;
        }

        @Override
        public /* synthetic */ PositionSource read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    }
}

