/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    public final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<b> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> var0, LevelCallback<T> var1, EntityPersistentStorage<T> var2) {
        this.visibleEntityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(var0, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)b.FRESH);
        this.callbacks = var1;
        this.permanentStorage = var2;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    void removeSectionIfEmpty(long var0, EntitySection<T> var2) {
        if (var2.isEmpty()) {
            this.sectionStorage.remove(var0);
        }
    }

    private boolean addEntityUuid(T var0) {
        if (!this.knownUuids.add(var0.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", var0);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T var0) {
        return this.addEntity(var0, false);
    }

    private boolean addEntity(T var0, boolean var1) {
        Visibility var5;
        if (!this.addEntityUuid(var0)) {
            return false;
        }
        long var2 = SectionPosition.asLong(var0.blockPosition());
        EntitySection<T> var4 = this.sectionStorage.getOrCreateSection(var2);
        var4.add(var0);
        var0.setLevelCallback(new a((EntityAccess)var0, var2, var4));
        if (!var1) {
            this.callbacks.onCreated(var0);
        }
        if ((var5 = PersistentEntitySectionManager.getEffectiveStatus(var0, var4.getStatus())).isAccessible()) {
            this.startTracking(var0);
        }
        if (var5.isTicking()) {
            this.startTicking(var0);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T var0, Visibility var1) {
        return var0.isAlwaysTicking() ? Visibility.TICKING : var1;
    }

    public void addLegacyChunkEntities(Stream<T> var02) {
        var02.forEach(var0 -> this.addEntity(var0, true));
    }

    public void addWorldGenChunkEntities(Stream<T> var02) {
        var02.forEach(var0 -> this.addEntity(var0, false));
    }

    void startTicking(T var0) {
        this.callbacks.onTickingStart(var0);
    }

    void stopTicking(T var0) {
        this.callbacks.onTickingEnd(var0);
    }

    void startTracking(T var0) {
        this.visibleEntityStorage.add(var0);
        this.callbacks.onTrackingStart(var0);
    }

    void stopTracking(T var0) {
        this.callbacks.onTrackingEnd(var0);
        this.visibleEntityStorage.remove(var0);
    }

    public void updateChunkStatus(ChunkCoordIntPair var0, FullChunkStatus var1) {
        Visibility var2 = Visibility.fromFullChunkStatus(var1);
        this.updateChunkStatus(var0, var2);
    }

    public void updateChunkStatus(ChunkCoordIntPair var0, Visibility var12) {
        long var2 = var0.toLong();
        if (var12 == Visibility.HIDDEN) {
            this.chunkVisibility.remove(var2);
            this.chunksToUnload.add(var2);
        } else {
            this.chunkVisibility.put(var2, (Object)var12);
            this.chunksToUnload.remove(var2);
            this.ensureChunkQueuedForLoad(var2);
        }
        this.sectionStorage.getExistingSectionsInChunk(var2).forEach(var1 -> {
            Visibility var2 = var1.updateChunkStatus(var12);
            boolean var3 = var2.isAccessible();
            boolean var4 = var12.isAccessible();
            boolean var5 = var2.isTicking();
            boolean var6 = var12.isTicking();
            if (var5 && !var6) {
                var1.getEntities().filter(var0 -> !var0.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (var3 && !var4) {
                var1.getEntities().filter(var0 -> !var0.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!var3 && var4) {
                var1.getEntities().filter(var0 -> !var0.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!var5 && var6) {
                var1.getEntities().filter(var0 -> !var0.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    public void ensureChunkQueuedForLoad(long var0) {
        b var2 = (b)((Object)this.chunkLoadStatuses.get(var0));
        if (var2 == b.FRESH) {
            this.requestChunkLoad(var0);
        }
    }

    private boolean storeChunkSections(long var02, Consumer<T> var2) {
        b var3 = (b)((Object)this.chunkLoadStatuses.get(var02));
        if (var3 == b.PENDING) {
            return false;
        }
        List<T> var4 = this.sectionStorage.getExistingSectionsInChunk(var02).flatMap(var0 -> var0.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (var4.isEmpty()) {
            if (var3 == b.LOADED) {
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkCoordIntPair(var02), ImmutableList.of()));
            }
            return true;
        }
        if (var3 == b.FRESH) {
            this.requestChunkLoad(var02);
            return false;
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkCoordIntPair(var02), var4));
        var4.forEach(var2);
        return true;
    }

    private void requestChunkLoad(long var0) {
        this.chunkLoadStatuses.put(var0, (Object)b.PENDING);
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var0);
        ((CompletableFuture)this.permanentStorage.loadEntities(var2).thenAccept(this.loadingInbox::add)).exceptionally(var1 -> {
            LOGGER.error("Failed to read chunk {}", (Object)var2, var1);
            return null;
        });
    }

    private boolean processChunkUnload(long var02) {
        boolean var2 = this.storeChunkSections(var02, var0 -> var0.getPassengersAndSelf().forEach(this::unloadEntity));
        if (!var2) {
            return false;
        }
        this.chunkLoadStatuses.remove(var02);
        return true;
    }

    private void unloadEntity(EntityAccess var0) {
        var0.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        var0.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(var0 -> {
            if (this.chunkVisibility.get(var0) != Visibility.HIDDEN) {
                return true;
            }
            return this.processChunkUnload(var0);
        });
    }

    private void processPendingLoads() {
        ChunkEntities<T> var02;
        while ((var02 = this.loadingInbox.poll()) != null) {
            var02.getEntities().forEach(var0 -> this.addEntity(var0, true));
            this.chunkLoadStatuses.put(var02.getPos().toLong(), (Object)b.LOADED);
        }
    }

    public void tick() {
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet var0 = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry var2 : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (var2.getValue() != b.LOADED) continue;
            var0.add(var2.getLongKey());
        }
        return var0;
    }

    public void autoSave() {
        this.getAllChunksToSave().forEach(var02 -> {
            boolean var2;
            boolean bl = var2 = this.chunkVisibility.get(var02) == Visibility.HIDDEN;
            if (var2) {
                this.processChunkUnload(var02);
            } else {
                this.storeChunkSections(var02, var0 -> {});
            }
        });
    }

    public void saveAll() {
        LongSet var0 = this.getAllChunksToSave();
        while (!var0.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            var0.removeIf(var02 -> {
                boolean var2 = this.chunkVisibility.get(var02) == Visibility.HIDDEN;
                return var2 ? this.processChunkUnload(var02) : this.storeChunkSections(var02, var0 -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.saveAll();
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID var0) {
        return this.knownUuids.contains(var0);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPosition var0) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkCoordIntPair.asLong(var0)))).isTicking();
    }

    public boolean canPositionTick(ChunkCoordIntPair var0) {
        return ((Visibility)((Object)this.chunkVisibility.get(var0.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long var0) {
        return this.chunkLoadStatuses.get(var0) == b.LOADED;
    }

    public void dumpSections(Writer var0) throws IOException {
        CSVWriter var12 = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(var0);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(var1 -> {
            b var3 = (b)((Object)((Object)this.chunkLoadStatuses.get(var1)));
            this.sectionStorage.getExistingSectionPositionsInChunk(var1).forEach(var2 -> {
                EntitySection<T> var4 = this.sectionStorage.getSection(var2);
                if (var4 != null) {
                    try {
                        var12.writeRow(new Object[]{SectionPosition.x(var2), SectionPosition.y(var2), SectionPosition.z(var2), var4.getStatus(), var3, var4.size()});
                    }
                    catch (IOException var5) {
                        throw new UncheckedIOException(var5);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        return this.knownUuids.size() + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b FRESH = new b();
        public static final /* enum */ b PENDING = new b();
        public static final /* enum */ b LOADED = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{FRESH, PENDING, LOADED};
        }

        static {
            d = b.a();
        }
    }

    class a
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;

        a(EntityAccess var1, long var2, EntitySection var4) {
            this.entity = var1;
            this.currentSectionKey = var2;
            this.currentSection = var4;
        }

        @Override
        public void onMove() {
            BlockPosition var0 = this.entity.blockPosition();
            long var1 = SectionPosition.asLong(var0);
            if (var1 != this.currentSectionKey) {
                Visibility var3 = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPosition.of(this.currentSectionKey), var1});
                }
                PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection var4 = PersistentEntitySectionManager.this.sectionStorage.getOrCreateSection(var1);
                var4.add(this.entity);
                this.currentSection = var4;
                this.currentSectionKey = var1;
                this.updateStatus(var3, var4.getStatus());
            }
        }

        private void updateStatus(Visibility var0, Visibility var1) {
            Visibility var3;
            Visibility var2 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, var0);
            if (var2 == (var3 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, var1))) {
                if (var3.isAccessible()) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
                return;
            }
            boolean var4 = var2.isAccessible();
            boolean var5 = var3.isAccessible();
            if (var4 && !var5) {
                PersistentEntitySectionManager.this.stopTracking(this.entity);
            } else if (!var4 && var5) {
                PersistentEntitySectionManager.this.startTracking(this.entity);
            }
            boolean var6 = var2.isTicking();
            boolean var7 = var3.isTicking();
            if (var6 && !var7) {
                PersistentEntitySectionManager.this.stopTicking(this.entity);
            } else if (!var6 && var7) {
                PersistentEntitySectionManager.this.startTicking(this.entity);
            }
            if (var5) {
                PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason var0) {
            Visibility var1;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPosition.of(this.currentSectionKey), var0});
            }
            if ((var1 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                PersistentEntitySectionManager.this.stopTicking(this.entity);
            }
            if (var1.isAccessible()) {
                PersistentEntitySectionManager.this.stopTracking(this.entity);
            }
            if (var0.shouldDestroy()) {
                PersistentEntitySectionManager.this.callbacks.onDestroyed(this.entity);
            }
            PersistentEntitySectionManager.this.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

