/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import org.slf4j.Logger;

public class ChunkRegionLoader {
    public static final Codec<DataPaletteBlock<IBlockData>> BLOCK_STATE_CODEC = DataPaletteBlock.codecRW(Block.BLOCK_STATE_REGISTRY, IBlockData.CODEC, DataPaletteBlock.d.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(WorldServer var02, VillagePlace var1, ChunkCoordIntPair var22, NBTTagCompound var3) {
        int var27;
        NBTTagList var26;
        IChunkAccess var20;
        Object var21;
        Object var23;
        EnumSet<HeightMap.Type> var222;
        ChunkCoordIntPair var4 = new ChunkCoordIntPair(var3.getInt(X_POS_TAG), var3.getInt(Z_POS_TAG));
        if (!Objects.equals(var22, var4)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{var22, var22, var4});
        }
        ChunkConverter var5 = var3.contains(TAG_UPGRADE_DATA, 10) ? new ChunkConverter(var3.getCompound(TAG_UPGRADE_DATA), var02) : ChunkConverter.EMPTY;
        boolean var6 = var3.getBoolean(IS_LIGHT_ON_TAG);
        NBTTagList var7 = var3.getList(SECTIONS_TAG, 10);
        int var8 = var02.getSectionsCount();
        ChunkSection[] var9 = new ChunkSection[var8];
        boolean var10 = var02.dimensionType().hasSkyLight();
        ChunkProviderServer var11 = var02.getChunkSource();
        LevelLightEngine var12 = ((IChunkProvider)var11).getLightEngine();
        IRegistry<BiomeBase> var13 = var02.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var14 = ChunkRegionLoader.makeBiomeCodec(var13);
        boolean var15 = false;
        for (int var16 = 0; var16 < var7.size(); ++var16) {
            boolean var212;
            NBTTagCompound var17 = var7.getCompound(var16);
            byte var18 = var17.getByte("Y");
            int var19 = var02.getSectionIndexFromSectionY(var18);
            if (var19 >= 0 && var19 < var9.length) {
                DataPaletteBlock<Holder<BiomeBase>> var213;
                DataPaletteBlock<IBlockData> var202;
                if (var17.contains("block_states", 10)) {
                    DataPaletteBlock var203 = (DataPaletteBlock)BLOCK_STATE_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var17.getCompound("block_states")).promotePartial(var2 -> ChunkRegionLoader.logErrors(var22, var18, var2)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                } else {
                    var202 = new DataPaletteBlock<IBlockData>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.d.SECTION_STATES);
                }
                if (var17.contains("biomes", 10)) {
                    PalettedContainerRO var214 = (PalettedContainerRO)var14.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var17.getCompound("biomes")).promotePartial(var2 -> ChunkRegionLoader.logErrors(var22, var18, var2)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                } else {
                    var213 = new DataPaletteBlock<Holder<BiomeBase>>(var13.asHolderIdMap(), var13.getHolderOrThrow(Biomes.PLAINS), DataPaletteBlock.d.SECTION_BIOMES);
                }
                var222 = new ChunkSection(var202, var213);
                var9[var19] = var222;
                var23 = SectionPosition.of(var22, var18);
                var1.checkConsistencyWithBlocks((SectionPosition)var23, (ChunkSection)((Object)var222));
            }
            boolean var203 = var17.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = var212 = var10 && var17.contains(SKY_LIGHT_TAG, 7);
            if (!var203 && !var212) continue;
            if (!var15) {
                var12.retainData(var22, true);
                var15 = true;
            }
            if (var203) {
                var12.queueSectionData(EnumSkyBlock.BLOCK, SectionPosition.of(var22, var18), new NibbleArray(var17.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!var212) continue;
            var12.queueSectionData(EnumSkyBlock.SKY, SectionPosition.of(var22, var18), new NibbleArray(var17.getByteArray(SKY_LIGHT_TAG)));
        }
        long var16 = var3.getLong("InhabitedTime");
        ChunkStatus.Type var18 = ChunkRegionLoader.getChunkTypeFromTag(var3);
        BlendingData var19 = var3.contains("blending_data", 10) ? (BlendingData)BlendingData.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var3.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        if (var18 == ChunkStatus.Type.LEVELCHUNK) {
            var21 = LevelChunkTicks.load(var3.getList(BLOCK_TICKS_TAG, 10), var0 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(var0)), var22);
            LevelChunkTicks<FluidType> var2222 = LevelChunkTicks.load(var3.getList(FLUID_TICKS_TAG, 10), var0 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(var0)), var22);
            var20 = new Chunk(var02.getLevel(), var22, var5, (LevelChunkTicks<Block>)var21, var2222, var16, var9, ChunkRegionLoader.postLoadChunk(var02, var3), var19);
        } else {
            var21 = ProtoChunkTickList.load(var3.getList(BLOCK_TICKS_TAG, 10), var0 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(var0)), var22);
            var222 = ProtoChunkTickList.load(var3.getList(FLUID_TICKS_TAG, 10), var0 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(var0)), var22);
            var23 = new ProtoChunk(var22, var5, var9, (ProtoChunkTickList<Block>)var21, (ProtoChunkTickList<FluidType>)((Object)var222), var02, var13, var19);
            var20 = var23;
            var20.setInhabitedTime(var16);
            if (var3.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var3.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(arg_0 -> var23.setBelowZeroRetrogen(arg_0));
            }
            ChunkStatus chunkStatus = ChunkStatus.byName(var3.getString("Status"));
            ((ProtoChunk)var23).setStatus(chunkStatus);
            if (chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                ((ProtoChunk)var23).setLightEngine(var12);
            }
        }
        var20.setLightCorrect(var6);
        var21 = var3.getCompound(HEIGHTMAPS_TAG);
        var222 = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type type : var20.getStatus().heightmapsAfter()) {
            String var25 = type.getSerializationKey();
            if (((NBTTagCompound)var21).contains(var25, 12)) {
                var20.setHeightmap(type, ((NBTTagCompound)var21).getLongArray(var25));
                continue;
            }
            var222.add(type);
        }
        HeightMap.primeHeightmaps(var20, var222);
        var23 = var3.getCompound("structures");
        var20.setAllStarts(ChunkRegionLoader.unpackStructureStart(StructurePieceSerializationContext.fromLevel(var02), (NBTTagCompound)var23, var02.getSeed()));
        var20.setAllReferences(ChunkRegionLoader.unpackStructureReferences(var02.registryAccess(), var22, (NBTTagCompound)var23));
        if (var3.getBoolean("shouldSave")) {
            var20.setUnsaved(true);
        }
        NBTTagList nBTTagList = var3.getList("PostProcessing", 9);
        for (int var25 = 0; var25 < nBTTagList.size(); ++var25) {
            var26 = nBTTagList.getList(var25);
            for (var27 = 0; var27 < var26.size(); ++var27) {
                var20.addPackedPostProcess(var26.getShort(var27), var25);
            }
        }
        if (var18 == ChunkStatus.Type.LEVELCHUNK) {
            return new ProtoChunkExtension((Chunk)var20, false);
        }
        ProtoChunk var25 = (ProtoChunk)var20;
        var26 = var3.getList("entities", 10);
        for (var27 = 0; var27 < var26.size(); ++var27) {
            var25.addEntity(var26.getCompound(var27));
        }
        NBTTagList var272 = var3.getList("block_entities", 10);
        for (int var28 = 0; var28 < var272.size(); ++var28) {
            NBTTagCompound var29 = var272.getCompound(var28);
            var20.setBlockEntityNbt(var29);
        }
        NBTTagCompound var28 = var3.getCompound("CarvingMasks");
        for (String var30 : var28.getAllKeys()) {
            WorldGenStage.Features var31 = WorldGenStage.Features.valueOf(var30);
            var25.setCarvingMask(var31, new CarvingMask(var28.getLongArray(var30), var20.getMinBuildHeight()));
        }
        return var25;
    }

    private static void logErrors(ChunkCoordIntPair var0, int var1, String var2) {
        LOGGER.error("Recoverable errors when loading section [" + var0.x + ", " + var1 + ", " + var0.z + "]: " + var2);
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> makeBiomeCodec(IRegistry<BiomeBase> var0) {
        return DataPaletteBlock.codecRO(var0.asHolderIdMap(), var0.holderByNameCodec(), DataPaletteBlock.d.SECTION_BIOMES, var0.getHolderOrThrow(Biomes.PLAINS));
    }

    public static NBTTagCompound write(WorldServer var0, IChunkAccess var12) {
        Object var14;
        ChunkConverter var6;
        BelowZeroRetrogen var5;
        ChunkCoordIntPair var2 = var12.getPos();
        NBTTagCompound var3 = GameProfileSerializer.addCurrentDataVersion(new NBTTagCompound());
        var3.putInt(X_POS_TAG, var2.x);
        var3.putInt("yPos", var12.getMinSection());
        var3.putInt(Z_POS_TAG, var2.z);
        var3.putLong("LastUpdate", var0.getGameTime());
        var3.putLong("InhabitedTime", var12.getInhabitedTime());
        var3.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(var12.getStatus()).toString());
        BlendingData var4 = var12.getBlendingData();
        if (var4 != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var4).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var3.put("blending_data", (NBTBase)var1));
        }
        if ((var5 = var12.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var5).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var3.put("below_zero_retrogen", (NBTBase)var1));
        }
        if (!(var6 = var12.getUpgradeData()).isEmpty()) {
            var3.put(TAG_UPGRADE_DATA, var6.write());
        }
        ChunkSection[] var7 = var12.getSections();
        NBTTagList var8 = new NBTTagList();
        LightEngineThreaded var9 = var0.getChunkSource().getLightEngine();
        IRegistry<BiomeBase> var10 = var0.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var11 = ChunkRegionLoader.makeBiomeCodec(var10);
        boolean var122 = var12.isLightCorrect();
        for (int var13 = var9.getMinLightSection(); var13 < var9.getMaxLightSection(); ++var13) {
            int var142 = var12.getSectionIndexFromSectionY(var13);
            boolean var15 = var142 >= 0 && var142 < var7.length;
            NibbleArray nibbleArray = var9.getLayerListener(EnumSkyBlock.BLOCK).getDataLayerData(SectionPosition.of(var2, var13));
            NibbleArray var17 = var9.getLayerListener(EnumSkyBlock.SKY).getDataLayerData(SectionPosition.of(var2, var13));
            if (!var15 && nibbleArray == null && var17 == null) continue;
            NBTTagCompound var18 = new NBTTagCompound();
            if (var15) {
                ChunkSection var19 = var7[var142];
                var18.put("block_states", (NBTBase)BLOCK_STATE_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var19.getStates()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                var18.put("biomes", (NBTBase)var11.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var19.getBiomes()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            }
            if (nibbleArray != null && !nibbleArray.isEmpty()) {
                var18.putByteArray(BLOCK_LIGHT_TAG, nibbleArray.getData());
            }
            if (var17 != null && !var17.isEmpty()) {
                var18.putByteArray(SKY_LIGHT_TAG, var17.getData());
            }
            if (var18.isEmpty()) continue;
            var18.putByte("Y", (byte)var13);
            var8.add(var18);
        }
        var3.put(SECTIONS_TAG, var8);
        if (var122) {
            var3.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        NBTTagList var13 = new NBTTagList();
        for (BlockPosition var15 : var12.getBlockEntitiesPos()) {
            NBTTagCompound nBTTagCompound = var12.getBlockEntityNbtForSaving(var15);
            if (nBTTagCompound == null) continue;
            var13.add(nBTTagCompound);
        }
        var3.put("block_entities", var13);
        if (var12.getStatus().getChunkType() == ChunkStatus.Type.PROTOCHUNK) {
            var14 = (ProtoChunk)var12;
            NBTTagList var15 = new NBTTagList();
            var15.addAll(((ProtoChunk)var14).getEntities());
            var3.put("entities", var15);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (WorldGenStage.Features var20 : WorldGenStage.Features.values()) {
                CarvingMask var21 = ((ProtoChunk)var14).getCarvingMask(var20);
                if (var21 == null) continue;
                nBTTagCompound.putLongArray(var20.toString(), var21.toArray());
            }
            var3.put("CarvingMasks", nBTTagCompound);
        }
        ChunkRegionLoader.saveTicks(var0, var3, var12.getTicksForSerialization());
        var3.put("PostProcessing", ChunkRegionLoader.packOffsets(var12.getPostProcessing()));
        var14 = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : var12.getHeightmaps()) {
            if (!var12.getStatus().heightmapsAfter().contains(entry.getKey())) continue;
            ((NBTTagCompound)var14).put(entry.getKey().getSerializationKey(), new NBTTagLongArray(entry.getValue().getRawData()));
        }
        var3.put(HEIGHTMAPS_TAG, (NBTBase)var14);
        var3.put("structures", ChunkRegionLoader.packStructureData(StructurePieceSerializationContext.fromLevel(var0), var2, var12.getAllStarts(), var12.getAllReferences()));
        return var3;
    }

    private static void saveTicks(WorldServer var02, NBTTagCompound var1, IChunkAccess.a var2) {
        long var3 = var02.getLevelData().getGameTime();
        var1.put(BLOCK_TICKS_TAG, var2.blocks().save(var3, var0 -> BuiltInRegistries.BLOCK.getKey((Block)var0).toString()));
        var1.put(FLUID_TICKS_TAG, var2.fluids().save(var3, var0 -> BuiltInRegistries.FLUID.getKey((FluidType)var0).toString()));
    }

    public static ChunkStatus.Type getChunkTypeFromTag(@Nullable NBTTagCompound var0) {
        if (var0 != null) {
            return ChunkStatus.byName(var0.getString("Status")).getChunkType();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    @Nullable
    private static Chunk.c postLoadChunk(WorldServer var0, NBTTagCompound var1) {
        NBTTagList var2 = ChunkRegionLoader.getListOfCompoundsOrNull(var1, "entities");
        NBTTagList var32 = ChunkRegionLoader.getListOfCompoundsOrNull(var1, "block_entities");
        if (var2 == null && var32 == null) {
            return null;
        }
        return var3 -> {
            if (var2 != null) {
                var0.addLegacyChunkEntities(EntityTypes.loadEntitiesRecursive(var2, var0));
            }
            if (var32 != null) {
                for (int var4 = 0; var4 < var32.size(); ++var4) {
                    NBTTagCompound var5 = var32.getCompound(var4);
                    boolean var6 = var5.getBoolean("keepPacked");
                    if (var6) {
                        var3.setBlockEntityNbt(var5);
                        continue;
                    }
                    BlockPosition var7 = TileEntity.getPosFromTag(var5);
                    TileEntity var8 = TileEntity.loadStatic(var7, var3.getBlockState(var7), var5);
                    if (var8 == null) continue;
                    var3.setBlockEntity(var8);
                }
            }
        };
    }

    @Nullable
    private static NBTTagList getListOfCompoundsOrNull(NBTTagCompound var0, String var1) {
        NBTTagList var2 = var0.getList(var1, 10);
        return var2.isEmpty() ? null : var2;
    }

    private static NBTTagCompound packStructureData(StructurePieceSerializationContext var0, ChunkCoordIntPair var1, Map<Structure, StructureStart> var2, Map<Structure, LongSet> var3) {
        NBTTagCompound var4 = new NBTTagCompound();
        NBTTagCompound var5 = new NBTTagCompound();
        IRegistry<Structure> var6 = var0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> var8 : var2.entrySet()) {
            Map.Entry<Structure, LongSet> var9 = var6.getKey(var8.getKey());
            var5.put(((MinecraftKey)((Object)var9)).toString(), var8.getValue().createTag(var0, var1));
        }
        var4.put("starts", var5);
        NBTTagCompound var7 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> var9 : var3.entrySet()) {
            if (((LongSet)var9.getValue()).isEmpty()) continue;
            MinecraftKey var10 = var6.getKey((Structure)var9.getKey());
            var7.put(var10.toString(), new NBTTagLongArray((LongSet)var9.getValue()));
        }
        var4.put("References", var7);
        return var4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        HashMap var4 = Maps.newHashMap();
        IRegistry<Structure> var5 = var0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        NBTTagCompound var6 = var1.getCompound("starts");
        for (String var8 : var6.getAllKeys()) {
            MinecraftKey var9 = MinecraftKey.tryParse(var8);
            Structure var10 = var5.get(var9);
            if (var10 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)var9);
                continue;
            }
            StructureStart var11 = StructureStart.loadStaticStart(var0, var6.getCompound(var8), var2);
            if (var11 == null) continue;
            var4.put(var10, var11);
        }
        return var4;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(IRegistryCustom var0, ChunkCoordIntPair var1, NBTTagCompound var22) {
        HashMap var3 = Maps.newHashMap();
        IRegistry<Structure> var4 = var0.registryOrThrow(Registries.STRUCTURE);
        NBTTagCompound var5 = var22.getCompound("References");
        for (String var7 : var5.getAllKeys()) {
            MinecraftKey var8 = MinecraftKey.tryParse(var7);
            Structure var9 = var4.get(var8);
            if (var9 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)var8, (Object)var1);
                continue;
            }
            long[] var10 = var5.getLongArray(var7);
            if (var10.length == 0) continue;
            var3.put(var9, new LongOpenHashSet(Arrays.stream(var10).filter(var2 -> {
                ChunkCoordIntPair var4 = new ChunkCoordIntPair(var2);
                if (var4.getChessboardDistance(var1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{var8, var4, var1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return var3;
    }

    public static NBTTagList packOffsets(ShortList[] var0) {
        NBTTagList var1 = new NBTTagList();
        for (ShortList var5 : var0) {
            NBTTagList var6 = new NBTTagList();
            if (var5 != null) {
                for (Short var8 : var5) {
                    var6.add(NBTTagShort.valueOf(var8));
                }
            }
            var1.add(var6);
        }
        return var1;
    }
}

