/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SPAWN_TIME = 200;
    private static final int COOLDOWN_TIME = 40;
    private static final int ATTENTION_INTERVAL = 2400;
    private static final int EVENT_COOLDOWN = 1;
    private static final int GATEWAY_HEIGHT_ABOVE_SURFACE = 10;
    public long age;
    private int teleportCooldown;
    @Nullable
    public BlockPosition exitPortal;
    public boolean exactTeleport;

    public TileEntityEndGateway(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.END_GATEWAY, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putLong("Age", this.age);
        if (this.exitPortal != null) {
            var0.put("ExitPortal", GameProfileSerializer.writeBlockPos(this.exitPortal));
        }
        if (this.exactTeleport) {
            var0.putBoolean("ExactTeleport", true);
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        BlockPosition var1;
        super.load(var0);
        this.age = var0.getLong("Age");
        if (var0.contains("ExitPortal", 10) && World.isInSpawnableBounds(var1 = GameProfileSerializer.readBlockPos(var0.getCompound("ExitPortal")))) {
            this.exitPortal = var1;
        }
        this.exactTeleport = var0.getBoolean("ExactTeleport");
    }

    public static void beamAnimationTick(World var0, BlockPosition var1, IBlockData var2, TileEntityEndGateway var3) {
        ++var3.age;
        if (var3.isCoolingDown()) {
            --var3.teleportCooldown;
        }
    }

    public static void teleportTick(World var0, BlockPosition var1, IBlockData var2, TileEntityEndGateway var3) {
        boolean var4 = var3.isSpawning();
        boolean var5 = var3.isCoolingDown();
        ++var3.age;
        if (var5) {
            --var3.teleportCooldown;
        } else {
            List<Entity> var6 = var0.getEntitiesOfClass(Entity.class, new AxisAlignedBB(var1), TileEntityEndGateway::canEntityTeleport);
            if (!var6.isEmpty()) {
                TileEntityEndGateway.teleportEntity(var0, var1, var2, var6.get(var0.random.nextInt(var6.size())), var3);
            }
            if (var3.age % 2400L == 0L) {
                TileEntityEndGateway.triggerCooldown(var0, var1, var2, var3);
            }
        }
        if (var4 != var3.isSpawning() || var5 != var3.isCoolingDown()) {
            TileEntityEndGateway.setChanged(var0, var1, var2);
        }
    }

    public static boolean canEntityTeleport(Entity var0) {
        return IEntitySelector.NO_SPECTATORS.test(var0) && !var0.getRootVehicle().isOnPortalCooldown();
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent(float var0) {
        return MathHelper.clamp(((float)this.age + var0) / 200.0f, 0.0f, 1.0f);
    }

    public float getCooldownPercent(float var0) {
        return 1.0f - MathHelper.clamp(((float)this.teleportCooldown - var0) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    private static void triggerCooldown(World var0, BlockPosition var1, IBlockData var2, TileEntityEndGateway var3) {
        if (!var0.isClientSide) {
            var3.teleportCooldown = 40;
            var0.blockEvent(var1, var2.getBlock(), 1, 0);
            TileEntityEndGateway.setChanged(var0, var1, var2);
        }
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    public static void teleportEntity(World var0, BlockPosition var1, IBlockData var2, Entity var3, TileEntityEndGateway var4) {
        BlockPosition var6;
        if (!(var0 instanceof WorldServer) || var4.isCoolingDown()) {
            return;
        }
        WorldServer var5 = (WorldServer)var0;
        var4.teleportCooldown = 100;
        if (var4.exitPortal == null && var0.dimension() == World.END) {
            var6 = TileEntityEndGateway.findOrCreateValidTeleportPos(var5, var1);
            var6 = var6.above(10);
            LOGGER.debug("Creating portal at {}", (Object)var6);
            TileEntityEndGateway.spawnGatewayPortal(var5, var6, WorldGenEndGatewayConfiguration.knownExit(var1, false));
            var4.exitPortal = var6;
        }
        if (var4.exitPortal != null) {
            Entity var7;
            BlockPosition blockPosition = var6 = var4.exactTeleport ? var4.exitPortal : TileEntityEndGateway.findExitPosition(var0, var4.exitPortal);
            if (var3 instanceof EntityEnderPearl) {
                Entity var8 = ((EntityEnderPearl)var3).getOwner();
                if (var8 instanceof EntityPlayer) {
                    CriterionTriggers.ENTER_BLOCK.trigger((EntityPlayer)var8, var2);
                }
                if (var8 != null) {
                    var7 = var8;
                    var3.discard();
                } else {
                    var7 = var3;
                }
            } else {
                var7 = var3.getRootVehicle();
            }
            var7.setPortalCooldown();
            var7.teleportToWithTicket((double)var6.getX() + 0.5, var6.getY(), (double)var6.getZ() + 0.5);
        }
        TileEntityEndGateway.triggerCooldown(var0, var1, var2, var4);
    }

    private static BlockPosition findExitPosition(World var0, BlockPosition var1) {
        BlockPosition var2 = TileEntityEndGateway.findTallestBlock(var0, var1.offset(0, 2, 0), 5, false);
        LOGGER.debug("Best exit position for portal at {} is {}", (Object)var1, (Object)var2);
        return var2.above();
    }

    private static BlockPosition findOrCreateValidTeleportPos(WorldServer var02, BlockPosition var1) {
        Vec3D var22 = TileEntityEndGateway.findExitPortalXZPosTentative(var02, var1);
        Chunk var3 = TileEntityEndGateway.getChunk(var02, var22);
        BlockPosition var4 = TileEntityEndGateway.findValidSpawnInChunk(var3);
        if (var4 == null) {
            BlockPosition var5 = BlockPosition.containing(var22.x + 0.5, 75.0, var22.z + 0.5);
            LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)var5);
            var02.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(var0 -> var0.getHolder(EndFeatures.END_ISLAND)).ifPresent(var2 -> ((WorldGenFeatureConfigured)var2.value()).place(var02, var02.getChunkSource().getGenerator(), RandomSource.create(var5.asLong()), var5));
            var4 = var5;
        } else {
            LOGGER.debug("Found suitable block to teleport to: {}", (Object)var4);
        }
        return TileEntityEndGateway.findTallestBlock(var02, var4, 16, true);
    }

    private static Vec3D findExitPortalXZPosTentative(WorldServer var0, BlockPosition var1) {
        Vec3D var2 = new Vec3D(var1.getX(), 0.0, var1.getZ()).normalize();
        int var3 = 1024;
        Vec3D var4 = var2.scale(1024.0);
        int var5 = 16;
        while (!TileEntityEndGateway.isChunkEmpty(var0, var4) && var5-- > 0) {
            LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)var4);
            var4 = var4.add(var2.scale(-16.0));
        }
        var5 = 16;
        while (TileEntityEndGateway.isChunkEmpty(var0, var4) && var5-- > 0) {
            LOGGER.debug("Skipping forward past empty chunk at {}", (Object)var4);
            var4 = var4.add(var2.scale(16.0));
        }
        LOGGER.debug("Found chunk at {}", (Object)var4);
        return var4;
    }

    private static boolean isChunkEmpty(WorldServer var0, Vec3D var1) {
        return TileEntityEndGateway.getChunk(var0, var1).getHighestFilledSectionIndex() == -1;
    }

    private static BlockPosition findTallestBlock(IBlockAccess var0, BlockPosition var1, int var2, boolean var3) {
        BaseBlockPosition var4 = null;
        for (int var5 = -var2; var5 <= var2; ++var5) {
            block1: for (int var6 = -var2; var6 <= var2; ++var6) {
                if (var5 == 0 && var6 == 0 && !var3) continue;
                for (int var7 = var0.getMaxBuildHeight() - 1; var7 > (var4 == null ? var0.getMinBuildHeight() : var4.getY()); --var7) {
                    BlockPosition var8 = new BlockPosition(var1.getX() + var5, var7, var1.getZ() + var6);
                    IBlockData var9 = var0.getBlockState(var8);
                    if (!var9.isCollisionShapeFullBlock(var0, var8) || !var3 && var9.is(Blocks.BEDROCK)) continue;
                    var4 = var8;
                    continue block1;
                }
            }
        }
        return var4 == null ? var1 : var4;
    }

    private static Chunk getChunk(World var0, Vec3D var1) {
        return var0.getChunk(MathHelper.floor(var1.x / 16.0), MathHelper.floor(var1.z / 16.0));
    }

    @Nullable
    private static BlockPosition findValidSpawnInChunk(Chunk var0) {
        ChunkCoordIntPair var1 = var0.getPos();
        BlockPosition var2 = new BlockPosition(var1.getMinBlockX(), 30, var1.getMinBlockZ());
        int var3 = var0.getHighestSectionPosition() + 16 - 1;
        BlockPosition var4 = new BlockPosition(var1.getMaxBlockX(), var3, var1.getMaxBlockZ());
        BlockPosition var5 = null;
        double var6 = 0.0;
        for (BlockPosition var9 : BlockPosition.betweenClosed(var2, var4)) {
            IBlockData var10 = var0.getBlockState(var9);
            BlockPosition var11 = var9.above();
            BlockPosition var12 = var9.above(2);
            if (!var10.is(Blocks.END_STONE) || var0.getBlockState(var11).isCollisionShapeFullBlock(var0, var11) || var0.getBlockState(var12).isCollisionShapeFullBlock(var0, var12)) continue;
            double var13 = var9.distToCenterSqr(0.0, 0.0, 0.0);
            if (var5 != null && !(var13 < var6)) continue;
            var5 = var9;
            var6 = var13;
        }
        return var5;
    }

    private static void spawnGatewayPortal(WorldServer var0, BlockPosition var1, WorldGenEndGatewayConfiguration var2) {
        WorldGenerator.END_GATEWAY.place(var2, var0, var0.getChunkSource().getGenerator(), RandomSource.create(), var1);
    }

    @Override
    public boolean shouldRenderFace(EnumDirection var0) {
        return Block.shouldRenderFace(this.getBlockState(), this.level, this.getBlockPos(), var0, this.getBlockPos().relative(var0));
    }

    public int getParticleAmount() {
        int var0 = 0;
        for (EnumDirection var4 : EnumDirection.values()) {
            var0 += this.shouldRenderFace(var4) ? 1 : 0;
        }
        return var0;
    }

    public void setExitPosition(BlockPosition var0, boolean var1) {
        this.exactTeleport = var1;
        this.exitPortal = var0;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

