/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockSign
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final float AABB_OFFSET = 4.0f;
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private final BlockPropertyWood type;

    protected BlockSign(BlockBase.Info var0, BlockPropertyWood var1) {
        super(var0);
        this.type = var1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(IBlockData var0) {
        return true;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySign(var0, var1);
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        SignApplicator var9;
        ItemStack var6 = var3.getItemInHand(var4);
        Item var7 = var6.getItem();
        Item item = var6.getItem();
        SignApplicator var8 = item instanceof SignApplicator ? (var9 = (SignApplicator)((Object)item)) : null;
        boolean var14 = var8 != null && var3.mayBuild();
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign var10 = (TileEntitySign)tileEntity;
            if (var1.isClientSide) {
                return var14 || var10.isWaxed() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.CONSUME;
            }
            boolean var11 = var10.isFacingFrontText(var3);
            SignText var12 = var10.getText(var11);
            boolean var13 = var10.executeClickCommandsIfPresent(var3, var1, var2, var11);
            if (var10.isWaxed()) {
                var1.playSound(null, var10.getBlockPos(), SoundEffects.WAXED_SIGN_INTERACT_FAIL, SoundCategory.BLOCKS);
                return EnumInteractionResult.PASS;
            }
            if (var14 && !this.otherPlayerIsEditingSign(var3, var10) && var8.canApplyToSign(var12, var3) && var8.tryApplyToSign(var1, var10, var11, var3)) {
                if (!var3.isCreative()) {
                    var6.shrink(1);
                }
                var1.gameEvent(GameEvent.BLOCK_CHANGE, var10.getBlockPos(), GameEvent.a.of(var3, var10.getBlockState()));
                var3.awardStat(StatisticList.ITEM_USED.get(var7));
                return EnumInteractionResult.SUCCESS;
            }
            if (var13) {
                return EnumInteractionResult.SUCCESS;
            }
            if (!this.otherPlayerIsEditingSign(var3, var10) && var3.mayBuild() && this.hasEditableText(var3, var10, var11)) {
                this.openTextEdit(var3, var10, var11);
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    private boolean hasEditableText(EntityHuman var02, TileEntitySign var1, boolean var2) {
        SignText var3 = var1.getText(var2);
        return Arrays.stream(var3.getMessages(var02.isTextFilteringEnabled())).allMatch(var0 -> var0.equals(CommonComponents.EMPTY) || var0.getContents() instanceof LiteralContents);
    }

    public abstract float getYRotationDegrees(IBlockData var1);

    public Vec3D getSignHitboxCenterPosition(IBlockData var0) {
        return new Vec3D(0.5, 0.5, 0.5);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    public BlockPropertyWood type() {
        return this.type;
    }

    public static BlockPropertyWood getWoodType(Block var0) {
        BlockPropertyWood var1 = var0 instanceof BlockSign ? ((BlockSign)var0).type() : BlockPropertyWood.OAK;
        return var1;
    }

    public void openTextEdit(EntityHuman var0, TileEntitySign var1, boolean var2) {
        var1.setAllowedPlayerEditor(var0.getUUID());
        var0.openTextEdit(var1, var2);
    }

    private boolean otherPlayerIsEditingSign(EntityHuman var0, TileEntitySign var1) {
        UUID var2 = var1.getPlayerWhoMayEdit();
        return var2 != null && !var2.equals(var0.getUUID());
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockSign.createTickerHelper(var2, TileEntityTypes.SIGN, TileEntitySign::tick);
    }
}

