/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;

public class EnchantmentWeaponDamage
extends Enchantment {
    public static final int ALL = 0;
    public static final int UNDEAD = 1;
    public static final int ARTHROPODS = 2;
    private static final String[] NAMES = new String[]{"all", "undead", "arthropods"};
    private static final int[] MIN_COST = new int[]{1, 5, 5};
    private static final int[] LEVEL_COST = new int[]{11, 8, 8};
    private static final int[] LEVEL_COST_SPAN = new int[]{20, 20, 20};
    public final int type;

    public EnchantmentWeaponDamage(Enchantment.Rarity var0, int var1, EnumItemSlot ... var2) {
        super(var0, EnchantmentSlotType.WEAPON, var2);
        this.type = var1;
    }

    @Override
    public int getMinCost(int var0) {
        return MIN_COST[this.type] + (var0 - 1) * LEVEL_COST[this.type];
    }

    @Override
    public int getMaxCost(int var0) {
        return this.getMinCost(var0) + LEVEL_COST_SPAN[this.type];
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public float getDamageBonus(int var0, EnumMonsterType var1) {
        if (this.type == 0) {
            return 1.0f + (float)Math.max(0, var0 - 1) * 0.5f;
        }
        if (this.type == 1 && var1 == EnumMonsterType.UNDEAD) {
            return (float)var0 * 2.5f;
        }
        if (this.type == 2 && var1 == EnumMonsterType.ARTHROPOD) {
            return (float)var0 * 2.5f;
        }
        return 0.0f;
    }

    @Override
    public boolean checkCompatibility(Enchantment var0) {
        return !(var0 instanceof EnchantmentWeaponDamage);
    }

    @Override
    public boolean canEnchant(ItemStack var0) {
        if (var0.getItem() instanceof ItemAxe) {
            return true;
        }
        return super.canEnchant(var0);
    }

    @Override
    public void doPostAttack(EntityLiving var0, Entity var1, int var2) {
        if (var1 instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)var1;
            if (this.type == 2 && var2 > 0 && var3.getMobType() == EnumMonsterType.ARTHROPOD) {
                int var4 = 20 + var0.getRandom().nextInt(10 * var2);
                var3.addEffect(new MobEffect(MobEffects.MOVEMENT_SLOWDOWN, var4, 3));
            }
        }
    }
}

