/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworksFade
extends IRecipeComplex {
    private static final RecipeItemStack STAR_INGREDIENT = RecipeItemStack.of(Items.FIREWORK_STAR);

    public RecipeFireworksFade(MinecraftKey var0, CraftingBookCategory var1) {
        super(var0, var1);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof ItemDye) {
                var2 = true;
                continue;
            }
            if (STAR_INGREDIENT.test(var5)) {
                if (var3) {
                    return false;
                }
                var3 = true;
                continue;
            }
            return false;
        }
        return var3 && var2;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, IRegistryCustom var1) {
        ArrayList var2 = Lists.newArrayList();
        ItemStack var3 = null;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            Item var6 = var5.getItem();
            if (var6 instanceof ItemDye) {
                var2.add(((ItemDye)var6).getDyeColor().getFireworkColor());
                continue;
            }
            if (!STAR_INGREDIENT.test(var5)) continue;
            var3 = var5.copyWithCount(1);
        }
        if (var3 == null || var2.isEmpty()) {
            return ItemStack.EMPTY;
        }
        var3.getOrCreateTagElement("Explosion").putIntArray("FadeColors", var2);
        return var3;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR_FADE;
    }
}

