/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class ItemTrident
extends Item
implements ItemVanishable {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;
    private final Multimap<AttributeBase, AttributeModifier> defaultModifiers;

    public ItemTrident(Item.Info var0) {
        super(var0);
        ImmutableMultimap.Builder var1 = ImmutableMultimap.builder();
        var1.put((Object)GenericAttributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
        var1.put((Object)GenericAttributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = var1.build();
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 72000;
    }

    @Override
    public void releaseUsing(ItemStack var0, World var12, EntityLiving var2, int var3) {
        if (!(var2 instanceof EntityHuman)) {
            return;
        }
        EntityHuman var4 = (EntityHuman)var2;
        int var5 = this.getUseDuration(var0) - var3;
        if (var5 < 10) {
            return;
        }
        int var6 = EnchantmentManager.getRiptide(var0);
        if (var6 > 0 && !var4.isInWaterOrRain()) {
            return;
        }
        if (!var12.isClientSide) {
            var0.hurtAndBreak(1, var4, var1 -> var1.broadcastBreakEvent(var2.getUsedItemHand()));
            if (var6 == 0) {
                EntityThrownTrident var7 = new EntityThrownTrident(var12, (EntityLiving)var4, var0);
                var7.shootFromRotation(var4, var4.getXRot(), var4.getYRot(), 0.0f, 2.5f + (float)var6 * 0.5f, 1.0f);
                if (var4.getAbilities().instabuild) {
                    var7.pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                var12.addFreshEntity(var7);
                var12.playSound(null, var7, SoundEffects.TRIDENT_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!var4.getAbilities().instabuild) {
                    var4.getInventory().removeItem(var0);
                }
            }
        }
        var4.awardStat(StatisticList.ITEM_USED.get(this));
        if (var6 > 0) {
            float var7 = var4.getYRot();
            float var8 = var4.getXRot();
            float var9 = -MathHelper.sin(var7 * ((float)Math.PI / 180)) * MathHelper.cos(var8 * ((float)Math.PI / 180));
            float var10 = -MathHelper.sin(var8 * ((float)Math.PI / 180));
            float var11 = MathHelper.cos(var7 * ((float)Math.PI / 180)) * MathHelper.cos(var8 * ((float)Math.PI / 180));
            float var122 = MathHelper.sqrt(var9 * var9 + var10 * var10 + var11 * var11);
            float var13 = 3.0f * ((1.0f + (float)var6) / 4.0f);
            var4.push(var9 *= var13 / var122, var10 *= var13 / var122, var11 *= var13 / var122);
            var4.startAutoSpinAttack(20);
            if (var4.onGround()) {
                float var14 = 1.1999999f;
                var4.move(EnumMoveType.SELF, new Vec3D(0.0, 1.1999999284744263, 0.0));
            }
            SoundEffect var14 = var6 >= 3 ? SoundEffects.TRIDENT_RIPTIDE_3 : (var6 == 2 ? SoundEffects.TRIDENT_RIPTIDE_2 : SoundEffects.TRIDENT_RIPTIDE_1);
            var12.playSound(null, var4, var14, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var3.getDamageValue() >= var3.getMaxDamage() - 1) {
            return InteractionResultWrapper.fail(var3);
        }
        if (EnchantmentManager.getRiptide(var3) > 0 && !var1.isInWaterOrRain()) {
            return InteractionResultWrapper.fail(var3);
        }
        var1.startUsingItem(var2);
        return InteractionResultWrapper.consume(var3);
    }

    @Override
    public boolean hurtEnemy(ItemStack var02, EntityLiving var1, EntityLiving var2) {
        var02.hurtAndBreak(1, var2, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean mineBlock(ItemStack var02, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        if ((double)var2.getDestroySpeed(var1, var3) != 0.0) {
            var02.hurtAndBreak(2, var4, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> getDefaultAttributeModifiers(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.getDefaultAttributeModifiers(var0);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }
}

