/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemRecord
extends Item {
    private static final Map<SoundEffect, ItemRecord> BY_NAME = Maps.newHashMap();
    private final int analogOutput;
    private final SoundEffect sound;
    private final int lengthInTicks;

    protected ItemRecord(int var0, SoundEffect var1, Item.Info var2, int var3) {
        super(var2);
        this.analogOutput = var0;
        this.sound = var1;
        this.lengthInTicks = var3 * 20;
        BY_NAME.put(this.sound, this);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (!var3.is(Blocks.JUKEBOX) || var3.getValue(BlockJukeBox.HAS_RECORD).booleanValue()) {
            return EnumInteractionResult.PASS;
        }
        ItemStack var4 = var0.getItemInHand();
        if (!var1.isClientSide) {
            EntityHuman var5 = var0.getPlayer();
            TileEntity tileEntity = var1.getBlockEntity(var2);
            if (tileEntity instanceof TileEntityJukeBox) {
                TileEntityJukeBox var6 = (TileEntityJukeBox)tileEntity;
                var6.setFirstItem(var4.copy());
                var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var5, var3));
            }
            var4.shrink(1);
            if (var5 != null) {
                var5.awardStat(StatisticList.PLAY_RECORD);
            }
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    public int getAnalogOutput() {
        return this.analogOutput;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        var2.add(this.getDisplayName().withStyle(EnumChatFormat.GRAY));
    }

    public IChatMutableComponent getDisplayName() {
        return IChatBaseComponent.translatable(this.getDescriptionId() + ".desc");
    }

    @Nullable
    public static ItemRecord getBySound(SoundEffect var0) {
        return BY_NAME.get(var0);
    }

    public SoundEffect getSound() {
        return this.sound;
    }

    public int getLengthInTicks() {
        return this.lengthInTicks;
    }
}

