/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.IBlockData;

public class ItemBoneMeal
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public ItemBoneMeal(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        BlockPosition var3 = var2.relative(var0.getClickedFace());
        if (ItemBoneMeal.growCrop(var0.getItemInHand(), var1, var2)) {
            if (!var1.isClientSide) {
                var1.levelEvent(1505, var2, 0);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        IBlockData var4 = var1.getBlockState(var2);
        boolean var5 = var4.isFaceSturdy(var1, var2, var0.getClickedFace());
        if (var5 && ItemBoneMeal.growWaterPlant(var0.getItemInHand(), var1, var3, var0.getClickedFace())) {
            if (!var1.isClientSide) {
                var1.levelEvent(1505, var3, 0);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean growCrop(ItemStack var0, World var1, BlockPosition var2) {
        IBlockFragilePlantElement var4;
        IBlockData var3 = var1.getBlockState(var2);
        if (var3.getBlock() instanceof IBlockFragilePlantElement && (var4 = (IBlockFragilePlantElement)((Object)var3.getBlock())).isValidBonemealTarget(var1, var2, var3, var1.isClientSide)) {
            if (var1 instanceof WorldServer) {
                if (var4.isBonemealSuccess(var1, var1.random, var2, var3)) {
                    var4.performBonemeal((WorldServer)var1, var1.random, var2, var3);
                }
                var0.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack var02, World var12, BlockPosition var2, @Nullable EnumDirection var3) {
        if (!var12.getBlockState(var2).is(Blocks.WATER) || var12.getFluidState(var2).getAmount() != 8) {
            return false;
        }
        if (!(var12 instanceof WorldServer)) {
            return true;
        }
        RandomSource var4 = var12.getRandom();
        block0: for (int var5 = 0; var5 < 128; ++var5) {
            BlockPosition var6 = var2;
            IBlockData var7 = Blocks.SEAGRASS.defaultBlockState();
            for (int var8 = 0; var8 < var5 / 16; ++var8) {
                if (var12.getBlockState(var6 = var6.offset(var4.nextInt(3) - 1, (var4.nextInt(3) - 1) * var4.nextInt(3) / 2, var4.nextInt(3) - 1)).isCollisionShapeFullBlock(var12, var6)) continue block0;
            }
            Holder<BiomeBase> var8 = var12.getBiome(var6);
            if (var8.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                if (var5 == 0 && var3 != null && var3.getAxis().isHorizontal()) {
                    var7 = BuiltInRegistries.BLOCK.getTag(TagsBlock.WALL_CORALS).flatMap(var1 -> var1.getRandomElement(var0.random)).map(var0 -> ((Block)var0.value()).defaultBlockState()).orElse(var7);
                    if (var7.hasProperty(BlockCoralFanWallAbstract.FACING)) {
                        var7 = (IBlockData)var7.setValue(BlockCoralFanWallAbstract.FACING, var3);
                    }
                } else if (var4.nextInt(4) == 0) {
                    var7 = BuiltInRegistries.BLOCK.getTag(TagsBlock.UNDERWATER_BONEMEALS).flatMap(var1 -> var1.getRandomElement(var0.random)).map(var0 -> ((Block)var0.value()).defaultBlockState()).orElse(var7);
                }
            }
            if (var7.is(TagsBlock.WALL_CORALS, var0 -> var0.hasProperty(BlockCoralFanWallAbstract.FACING))) {
                for (int var9 = 0; !var7.canSurvive(var12, var6) && var9 < 4; ++var9) {
                    var7 = (IBlockData)var7.setValue(BlockCoralFanWallAbstract.FACING, EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var4));
                }
            }
            if (!var7.canSurvive(var12, var6)) continue;
            IBlockData var9 = var12.getBlockState(var6);
            if (var9.is(Blocks.WATER) && var12.getFluidState(var6).getAmount() == 8) {
                var12.setBlock(var6, var7, 3);
                continue;
            }
            if (!var9.is(Blocks.SEAGRASS) || var4.nextInt(10) != 0) continue;
            ((IBlockFragilePlantElement)((Object)Blocks.SEAGRASS)).performBonemeal((WorldServer)var12, var4, var6, var9);
        }
        var02.shrink(1);
        return true;
    }

    public static void addGrowthParticles(GeneratorAccess var0, BlockPosition var1, int var2) {
        double var6;
        IBlockData var3;
        if (var2 == 0) {
            var2 = 15;
        }
        if ((var3 = var0.getBlockState(var1)).isAir()) {
            return;
        }
        double var4 = 0.5;
        if (var3.is(Blocks.WATER)) {
            var2 *= 3;
            var6 = 1.0;
            var4 = 3.0;
        } else if (var3.isSolidRender(var0, var1)) {
            var1 = var1.above();
            var2 *= 3;
            var4 = 3.0;
            var6 = 1.0;
        } else {
            var6 = var3.getShape(var0, var1).max(EnumDirection.EnumAxis.Y);
        }
        var0.addParticle(Particles.HAPPY_VILLAGER, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, 0.0, 0.0, 0.0);
        RandomSource var8 = var0.getRandom();
        for (int var9 = 0; var9 < var2; ++var9) {
            double var22;
            double var20;
            double var10 = var8.nextGaussian() * 0.02;
            double var12 = var8.nextGaussian() * 0.02;
            double var14 = var8.nextGaussian() * 0.02;
            double var16 = 0.5 - var4;
            double var18 = (double)var1.getX() + var16 + var8.nextDouble() * var4 * 2.0;
            if (var0.getBlockState(BlockPosition.containing(var18, var20 = (double)var1.getY() + var8.nextDouble() * var6, var22 = (double)var1.getZ() + var16 + var8.nextDouble() * var4 * 2.0).below()).isAir()) continue;
            var0.addParticle(Particles.HAPPY_VILLAGER, var18, var20, var22, var10, var12, var14);
        }
    }
}

