/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.LazyInitVar;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class EnumArmorMaterial
extends Enum<EnumArmorMaterial>
implements INamable,
ArmorMaterial {
    public static final /* enum */ EnumArmorMaterial LEATHER = new EnumArmorMaterial("leather", 5, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 1);
        var0.put(ItemArmor.a.LEGGINGS, 2);
        var0.put(ItemArmor.a.CHESTPLATE, 3);
        var0.put(ItemArmor.a.HELMET, 1);
    }), 15, SoundEffects.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.LEATHER));
    public static final /* enum */ EnumArmorMaterial CHAIN = new EnumArmorMaterial("chainmail", 15, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 1);
        var0.put(ItemArmor.a.LEGGINGS, 4);
        var0.put(ItemArmor.a.CHESTPLATE, 5);
        var0.put(ItemArmor.a.HELMET, 2);
    }), 12, SoundEffects.ARMOR_EQUIP_CHAIN, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.IRON_INGOT));
    public static final /* enum */ EnumArmorMaterial IRON = new EnumArmorMaterial("iron", 15, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 2);
        var0.put(ItemArmor.a.LEGGINGS, 5);
        var0.put(ItemArmor.a.CHESTPLATE, 6);
        var0.put(ItemArmor.a.HELMET, 2);
    }), 9, SoundEffects.ARMOR_EQUIP_IRON, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.IRON_INGOT));
    public static final /* enum */ EnumArmorMaterial GOLD = new EnumArmorMaterial("gold", 7, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 1);
        var0.put(ItemArmor.a.LEGGINGS, 3);
        var0.put(ItemArmor.a.CHESTPLATE, 5);
        var0.put(ItemArmor.a.HELMET, 2);
    }), 25, SoundEffects.ARMOR_EQUIP_GOLD, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.GOLD_INGOT));
    public static final /* enum */ EnumArmorMaterial DIAMOND = new EnumArmorMaterial("diamond", 33, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 3);
        var0.put(ItemArmor.a.LEGGINGS, 6);
        var0.put(ItemArmor.a.CHESTPLATE, 8);
        var0.put(ItemArmor.a.HELMET, 3);
    }), 10, SoundEffects.ARMOR_EQUIP_DIAMOND, 2.0f, 0.0f, () -> RecipeItemStack.of(Items.DIAMOND));
    public static final /* enum */ EnumArmorMaterial TURTLE = new EnumArmorMaterial("turtle", 25, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 2);
        var0.put(ItemArmor.a.LEGGINGS, 5);
        var0.put(ItemArmor.a.CHESTPLATE, 6);
        var0.put(ItemArmor.a.HELMET, 2);
    }), 9, SoundEffects.ARMOR_EQUIP_TURTLE, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.SCUTE));
    public static final /* enum */ EnumArmorMaterial NETHERITE = new EnumArmorMaterial("netherite", 37, SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
        var0.put(ItemArmor.a.BOOTS, 3);
        var0.put(ItemArmor.a.LEGGINGS, 6);
        var0.put(ItemArmor.a.CHESTPLATE, 8);
        var0.put(ItemArmor.a.HELMET, 3);
    }), 15, SoundEffects.ARMOR_EQUIP_NETHERITE, 3.0f, 0.1f, () -> RecipeItemStack.of(Items.NETHERITE_INGOT));
    public static final INamable.a<EnumArmorMaterial> CODEC;
    private static final EnumMap<ItemArmor.a, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ItemArmor.a, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEffect sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyInitVar<RecipeItemStack> repairIngredient;
    private static final /* synthetic */ EnumArmorMaterial[] r;

    public static EnumArmorMaterial[] values() {
        return (EnumArmorMaterial[])r.clone();
    }

    public static EnumArmorMaterial valueOf(String var0) {
        return Enum.valueOf(EnumArmorMaterial.class, var0);
    }

    private EnumArmorMaterial(String var2, int var3, EnumMap var4, int var5, SoundEffect var6, float var7, float var8, Supplier var9) {
        this.name = var2;
        this.durabilityMultiplier = var3;
        this.protectionFunctionForType = var4;
        this.enchantmentValue = var5;
        this.sound = var6;
        this.toughness = var7;
        this.knockbackResistance = var8;
        this.repairIngredient = new LazyInitVar(var9);
    }

    @Override
    public int getDurabilityForType(ItemArmor.a var0) {
        return HEALTH_FUNCTION_FOR_TYPE.get((Object)var0) * this.durabilityMultiplier;
    }

    @Override
    public int getDefenseForType(ItemArmor.a var0) {
        return this.protectionFunctionForType.get((Object)var0);
    }

    @Override
    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @Override
    public SoundEffect getEquipSound() {
        return this.sound;
    }

    @Override
    public RecipeItemStack getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getToughness() {
        return this.toughness;
    }

    @Override
    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static /* synthetic */ EnumArmorMaterial[] o() {
        return new EnumArmorMaterial[]{LEATHER, CHAIN, IRON, GOLD, DIAMOND, TURTLE, NETHERITE};
    }

    static {
        r = EnumArmorMaterial.o();
        CODEC = INamable.fromEnum(EnumArmorMaterial::values);
        HEALTH_FUNCTION_FOR_TYPE = SystemUtils.make(new EnumMap(ItemArmor.a.class), var0 -> {
            var0.put(ItemArmor.a.BOOTS, 13);
            var0.put(ItemArmor.a.LEGGINGS, 15);
            var0.put(ItemArmor.a.CHESTPLATE, 16);
            var0.put(ItemArmor.a.HELMET, 11);
        });
    }
}

