/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipes;

public class SlotResult
extends Slot {
    private final InventoryCrafting craftSlots;
    private final EntityHuman player;
    private int removeCount;

    public SlotResult(EntityHuman var0, InventoryCrafting var1, IInventory var2, int var3, int var4, int var5) {
        super(var2, var3, var4, var5);
        this.player = var0;
        this.craftSlots = var1;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return false;
    }

    @Override
    public ItemStack remove(int var0) {
        if (this.hasItem()) {
            this.removeCount += Math.min(var0, this.getItem().getCount());
        }
        return super.remove(var0);
    }

    @Override
    protected void onQuickCraft(ItemStack var0, int var1) {
        this.removeCount += var1;
        this.checkTakeAchievements(var0);
    }

    @Override
    protected void onSwapCraft(int var0) {
        this.removeCount += var0;
    }

    @Override
    protected void checkTakeAchievements(ItemStack var0) {
        IInventory iInventory;
        if (this.removeCount > 0) {
            var0.onCraftedBy(this.player.level(), this.player, this.removeCount);
        }
        if ((iInventory = this.container) instanceof RecipeHolder) {
            RecipeHolder var1 = (RecipeHolder)((Object)iInventory);
            var1.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    @Override
    public void onTake(EntityHuman var0, ItemStack var1) {
        this.checkTakeAchievements(var1);
        NonNullList<ItemStack> var2 = var0.level().getRecipeManager().getRemainingItemsFor(Recipes.CRAFTING, this.craftSlots, var0.level());
        for (int var3 = 0; var3 < var2.size(); ++var3) {
            ItemStack var4 = this.craftSlots.getItem(var3);
            ItemStack var5 = var2.get(var3);
            if (!var4.isEmpty()) {
                this.craftSlots.removeItem(var3, 1);
                var4 = this.craftSlots.getItem(var3);
            }
            if (var5.isEmpty()) continue;
            if (var4.isEmpty()) {
                this.craftSlots.setItem(var3, var5);
                continue;
            }
            if (ItemStack.isSameItemSameTags(var4, var5)) {
                var5.grow(var4.getCount());
                this.craftSlots.setItem(var3, var5);
                continue;
            }
            if (this.player.getInventory().add(var5)) continue;
            this.player.drop(var5, false);
        }
    }
}

