/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerDispenser
extends Container {
    private static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    public final IInventory dispenser;

    public ContainerDispenser(int var0, PlayerInventory var1) {
        this(var0, var1, new InventorySubcontainer(9));
    }

    public ContainerDispenser(int var0, PlayerInventory var1, IInventory var2) {
        super(Containers.GENERIC_3x3, var0);
        int var4;
        int var3;
        ContainerDispenser.checkContainerSize(var2, 9);
        this.dispenser = var2;
        var2.startOpen(var1.player);
        for (var3 = 0; var3 < 3; ++var3) {
            for (var4 = 0; var4 < 3; ++var4) {
                this.addSlot(new Slot(var2, var4 + var3 * 3, 62 + var4 * 18, 17 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 3; ++var3) {
            for (var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.dispenser.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 < 9 ? !this.moveItemStackTo(var4, 9, 45, true) : !this.moveItemStackTo(var4, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.dispenser.stopOpen(var0);
    }
}

