/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.warden.Digging;
import net.minecraft.world.entity.ai.behavior.warden.Emerging;
import net.minecraft.world.entity.ai.behavior.warden.ForceUnmount;
import net.minecraft.world.entity.ai.behavior.warden.Roar;
import net.minecraft.world.entity.ai.behavior.warden.SetRoarTarget;
import net.minecraft.world.entity.ai.behavior.warden.SetWardenLookTarget;
import net.minecraft.world.entity.ai.behavior.warden.Sniffing;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.behavior.warden.TryToSniff;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.schedule.Activity;

public class WardenAi {
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_INVESTIGATING = 0.7f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.2f;
    private static final int MELEE_ATTACK_COOLDOWN = 18;
    private static final int DIGGING_DURATION = MathHelper.ceil(100.0f);
    public static final int EMERGE_DURATION = MathHelper.ceil(133.59999f);
    public static final int ROAR_DURATION = MathHelper.ceil(84.0f);
    private static final int SNIFFING_DURATION = MathHelper.ceil(83.2f);
    public static final int DIGGING_COOLDOWN = 1200;
    private static final int DISTURBANCE_LOCATION_EXPIRY_TIME = 100;
    private static final List<SensorType<? extends Sensor<? super Warden>>> SENSOR_TYPES = List.of(SensorType.NEAREST_PLAYERS, SensorType.WARDEN_ENTITY_SENSOR);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.ROAR_TARGET, MemoryModuleType.DISTURBANCE_LOCATION, MemoryModuleType.RECENT_PROJECTILE, MemoryModuleType.IS_SNIFFING, MemoryModuleType.IS_EMERGING, MemoryModuleType.ROAR_SOUND_DELAY, MemoryModuleType.DIG_COOLDOWN, MemoryModuleType.ROAR_SOUND_COOLDOWN, MemoryModuleType.SNIFF_COOLDOWN, MemoryModuleType.TOUCH_COOLDOWN, MemoryModuleType.VIBRATION_COOLDOWN, MemoryModuleType.SONIC_BOOM_COOLDOWN, MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, MemoryModuleType.SONIC_BOOM_SOUND_DELAY);
    private static final BehaviorControl<Warden> DIG_COOLDOWN_SETTER = BehaviorBuilder.create(var0 -> var0.group(var0.registered(MemoryModuleType.DIG_COOLDOWN)).apply((Applicative)var0, var1 -> (var2, var3, var4) -> {
        if (var0.tryGet(var1).isPresent()) {
            var1.setWithExpiry(Unit.INSTANCE, 1200L);
        }
        return true;
    }));

    public static void updateActivity(Warden var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.EMERGE, (Object)Activity.DIG, (Object)Activity.ROAR, (Object)Activity.FIGHT, (Object)Activity.INVESTIGATE, (Object)Activity.SNIFF, (Object)Activity.IDLE));
    }

    protected static BehaviorController<?> makeBrain(Warden var0, Dynamic<?> var1) {
        BehaviorController.b var2 = BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
        BehaviorController<Warden> var3 = var2.makeBrain(var1);
        WardenAi.initCoreActivity(var3);
        WardenAi.initEmergeActivity(var3);
        WardenAi.initDiggingActivity(var3);
        WardenAi.initIdleActivity(var3);
        WardenAi.initRoarActivity(var3);
        WardenAi.initFightActivity(var0, var3);
        WardenAi.initInvestigateActivity(var3);
        WardenAi.initSniffingActivity(var3);
        var3.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var3.setDefaultActivity(Activity.IDLE);
        var3.useDefaultActivity();
        return var3;
    }

    private static void initCoreActivity(BehaviorController<Warden> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of((Object)new BehaviorSwim(0.8f), SetWardenLookTarget.create(), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    private static void initEmergeActivity(BehaviorController<Warden> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of(new Emerging(EMERGE_DURATION)), MemoryModuleType.IS_EMERGING);
    }

    private static void initDiggingActivity(BehaviorController<Warden> var0) {
        var0.addActivityWithConditions(Activity.DIG, (ImmutableList<Pair<Integer, BehaviorControl<Warden>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new ForceUnmount()), (Object)Pair.of((Object)1, new Digging(DIGGING_DURATION))), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.ROAR_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), (Object)Pair.of(MemoryModuleType.DIG_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT))));
    }

    private static void initIdleActivity(BehaviorController<Warden> var0) {
        var0.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of(SetRoarTarget.create(Warden::getEntityAngryAt), TryToSniff.create(), new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.IS_SNIFFING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.5f), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(BehaviorController<Warden> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.INVESTIGATE, 5, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of(SetRoarTarget.create(Warden::getEntityAngryAt), GoToTargetLocation.create(MemoryModuleType.DISTURBANCE_LOCATION, 2, 0.7f)), MemoryModuleType.DISTURBANCE_LOCATION);
    }

    private static void initSniffingActivity(BehaviorController<Warden> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.SNIFF, 5, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of(SetRoarTarget.create(Warden::getEntityAngryAt), new Sniffing(SNIFFING_DURATION)), MemoryModuleType.IS_SNIFFING);
    }

    private static void initRoarActivity(BehaviorController<Warden> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.ROAR, 10, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of((Object)new Roar()), MemoryModuleType.ROAR_TARGET);
    }

    private static void initFightActivity(Warden var0, BehaviorController<Warden> var12) {
        var12.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Warden>>)ImmutableList.of(DIG_COOLDOWN_SETTER, BehaviorAttackTargetForget.create(var1 -> !var0.getAngerLevel().isAngry() || !var0.canTargetEntity((Entity)var1), WardenAi::onTargetInvalid, false), BehaviorLookTarget.create(var1 -> WardenAi.isTarget(var0, var1), (float)var0.getAttributeValue(GenericAttributes.FOLLOW_RANGE)), BehaviorWalkAwayOutOfRange.create(1.2f), (Object)new SonicBoom(), BehaviorAttack.create(18)), MemoryModuleType.ATTACK_TARGET);
    }

    private static boolean isTarget(Warden var0, EntityLiving var12) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).filter(var1 -> var1 == var12).isPresent();
    }

    private static void onTargetInvalid(Warden var0, EntityLiving var1) {
        if (!var0.canTargetEntity(var1)) {
            var0.clearAnger(var1);
        }
        WardenAi.setDigCooldown(var0);
    }

    public static void setDigCooldown(EntityLiving var0) {
        if (var0.getBrain().hasMemoryValue(MemoryModuleType.DIG_COOLDOWN)) {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.DIG_COOLDOWN, Unit.INSTANCE, 1200L);
        }
    }

    public static void setDisturbanceLocation(Warden var0, BlockPosition var1) {
        if (!var0.level().getWorldBorder().isWithinBounds(var1) || var0.getEntityAngryAt().isPresent() || var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent()) {
            return;
        }
        WardenAi.setDigCooldown(var0);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, Unit.INSTANCE, 100L);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(var1), 100L);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.DISTURBANCE_LOCATION, var1, 100L);
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

