/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntitySpider.class, DataWatcherRegistry.BYTE);
    private static final float SPIDER_SPECIAL_EFFECT_CHANCE = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.addGoal(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.targetSelector.addGoal(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public double getPassengersRidingOffset() {
        return this.getBbHeight() * 0.5f;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationSpider(this, var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 16.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SPIDER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SPIDER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SPIDER_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SPIDER_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean onClimbable() {
        return this.isClimbing();
    }

    @Override
    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
        if (!var0.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(var0, var1);
        }
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.ARTHROPOD;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(var0);
    }

    public boolean isClimbing() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean var0) {
        byte var1 = this.entityData.get(DATA_FLAGS_ID);
        var1 = var0 ? (byte)(var1 | 1) : (byte)(var1 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, var1);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        Object var6;
        var3 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        RandomSource var5 = var0.getRandom();
        if (var5.nextInt(100) == 0 && (var6 = EntityTypes.SKELETON.create(this.level())) != null) {
            ((Entity)var6).moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            ((EntitySkeletonAbstract)var6).finalizeSpawn(var0, var1, var2, null, null);
            ((Entity)var6).startRiding(this);
        }
        if (var3 == null) {
            var3 = new GroupDataSpider();
            if (var0.getDifficulty() == EnumDifficulty.HARD && var5.nextFloat() < 0.1f * var1.getSpecialMultiplier()) {
                ((GroupDataSpider)var3).setRandomEffect(var5);
            }
        }
        if (var3 instanceof GroupDataSpider) {
            var6 = (GroupDataSpider)var3;
            MobEffectList var7 = ((GroupDataSpider)var6).effect;
            if (var7 != null) {
                this.addEffect(new MobEffect(var7, -1));
            }
        }
        return var3;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.65f;
    }

    static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider var0) {
            super(var0, 1.0, true);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.mob.isVehicle();
        }

        @Override
        public boolean canContinueToUse() {
            float var0 = this.mob.getLightLevelDependentMagicValue();
            if (var0 >= 0.5f && this.mob.getRandom().nextInt(100) == 0) {
                this.mob.setTarget(null);
                return false;
            }
            return super.canContinueToUse();
        }

        @Override
        protected double getAttackReachSqr(EntityLiving var0) {
            return 4.0f + var0.getBbWidth();
        }
    }

    static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider var0, Class<T> var1) {
            super((EntityInsentient)var0, var1, true);
        }

        @Override
        public boolean canUse() {
            float var0 = this.mob.getLightLevelDependentMagicValue();
            if (var0 >= 0.5f) {
                return false;
            }
            return super.canUse();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public MobEffectList effect;

        public void setRandomEffect(RandomSource var0) {
            int var1 = var0.nextInt(5);
            if (var1 <= 1) {
                this.effect = MobEffects.MOVEMENT_SPEED;
            } else if (var1 <= 2) {
                this.effect = MobEffects.DAMAGE_BOOST;
            } else if (var1 <= 3) {
                this.effect = MobEffects.REGENERATION;
            } else if (var1 <= 4) {
                this.effect = MobEffects.INVISIBILITY;
            }
        }
    }
}

