/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class DragonControllerStrafe
extends AbstractDragonController {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int FIREBALL_CHARGE_AMOUNT = 5;
    private int fireballCharge;
    @Nullable
    private PathEntity currentPath;
    @Nullable
    private Vec3D targetLocation;
    @Nullable
    private EntityLiving attackTarget;
    private boolean holdingPatternClockwise;

    public DragonControllerStrafe(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doServerTick() {
        double var8;
        double var2;
        double var0;
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            return;
        }
        if (this.currentPath != null && this.currentPath.isDone()) {
            var0 = this.attackTarget.getX();
            var2 = this.attackTarget.getZ();
            double var4 = var0 - this.dragon.getX();
            double var6 = var2 - this.dragon.getZ();
            var8 = Math.sqrt(var4 * var4 + var6 * var6);
            double var10 = Math.min((double)0.4f + var8 / 80.0 - 1.0, 10.0);
            this.targetLocation = new Vec3D(var0, this.attackTarget.getY() + var10, var2);
        }
        double d2 = var0 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var0 < 100.0 || var0 > 22500.0) {
            this.findNewTarget();
        }
        var2 = 64.0;
        if (this.attackTarget.distanceToSqr(this.dragon) < 4096.0) {
            if (this.dragon.hasLineOfSight(this.attackTarget)) {
                ++this.fireballCharge;
                Vec3D var4 = new Vec3D(this.attackTarget.getX() - this.dragon.getX(), 0.0, this.attackTarget.getZ() - this.dragon.getZ()).normalize();
                Vec3D var5 = new Vec3D(MathHelper.sin(this.dragon.getYRot() * ((float)Math.PI / 180)), 0.0, -MathHelper.cos(this.dragon.getYRot() * ((float)Math.PI / 180))).normalize();
                float var6 = (float)var5.dot(var4);
                float var7 = (float)(Math.acos(var6) * 57.2957763671875);
                var7 += 0.5f;
                if (this.fireballCharge >= 5 && var7 >= 0.0f && var7 < 10.0f) {
                    var8 = 1.0;
                    Vec3D var10 = this.dragon.getViewVector(1.0f);
                    double var11 = this.dragon.head.getX() - var10.x * 1.0;
                    double var13 = this.dragon.head.getY(0.5) + 0.5;
                    double var15 = this.dragon.head.getZ() - var10.z * 1.0;
                    double var17 = this.attackTarget.getX() - var11;
                    double var19 = this.attackTarget.getY(0.5) - var13;
                    double var21 = this.attackTarget.getZ() - var15;
                    if (!this.dragon.isSilent()) {
                        this.dragon.level().levelEvent(null, 1017, this.dragon.blockPosition(), 0);
                    }
                    EntityDragonFireball var23 = new EntityDragonFireball(this.dragon.level(), this.dragon, var17, var19, var21);
                    var23.moveTo(var11, var13, var15, 0.0f, 0.0f);
                    this.dragon.level().addFreshEntity(var23);
                    this.fireballCharge = 0;
                    if (this.currentPath != null) {
                        while (!this.currentPath.isDone()) {
                            this.currentPath.advance();
                        }
                    }
                    this.dragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
                }
            } else if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
        } else if (this.fireballCharge > 0) {
            --this.fireballCharge;
        }
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var0;
            int var1 = var0 = this.dragon.findClosestNode();
            if (this.dragon.getRandom().nextInt(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                var1 += 6;
            }
            var1 = this.holdingPatternClockwise ? ++var1 : --var1;
            if (this.dragon.getDragonFight() == null || this.dragon.getDragonFight().getCrystalsAlive() <= 0) {
                var1 -= 12;
                var1 &= 7;
                var1 += 12;
            } else if ((var1 %= 12) < 0) {
                var1 += 12;
            }
            this.currentPath = this.dragon.findPath(var0, var1, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var3;
            BlockPosition var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var5 = var0.getZ();
            while ((var3 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3D(var1, var3, var5);
        }
    }

    @Override
    public void begin() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
    }

    public void setTarget(EntityLiving var0) {
        this.attackTarget = var0;
        int var1 = this.dragon.findClosestNode();
        int var2 = this.dragon.findClosestNode(this.attackTarget.getX(), this.attackTarget.getY(), this.attackTarget.getZ());
        int var3 = this.attackTarget.getBlockX();
        int var4 = this.attackTarget.getBlockZ();
        double var5 = (double)var3 - this.dragon.getX();
        double var7 = (double)var4 - this.dragon.getZ();
        double var9 = Math.sqrt(var5 * var5 + var7 * var7);
        double var11 = Math.min((double)0.4f + var9 / 80.0 - 1.0, 10.0);
        int var13 = MathHelper.floor(this.attackTarget.getY() + var11);
        PathPoint var14 = new PathPoint(var3, var13, var4);
        this.currentPath = this.dragon.findPath(var1, var2, var14);
        if (this.currentPath != null) {
            this.currentPath.advance();
            this.navigateToNextPathNode();
        }
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    public DragonControllerPhase<DragonControllerStrafe> getPhase() {
        return DragonControllerPhase.STRAFE_PLAYER;
    }
}

