/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorNearestLivingEntities;
import net.minecraft.world.entity.monster.warden.Warden;

public class WardenEntitySensor
extends SensorNearestLivingEntities<Warden> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat(super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    @Override
    protected void doTick(WorldServer var02, Warden var12) {
        super.doTick(var02, var12);
        WardenEntitySensor.getClosest(var12, var0 -> var0.getType() == EntityTypes.PLAYER).or(() -> WardenEntitySensor.getClosest(var12, var0 -> var0.getType() != EntityTypes.PLAYER)).ifPresentOrElse(var1 -> var12.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, var1), () -> var12.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }

    private static Optional<EntityLiving> getClosest(Warden var0, Predicate<EntityLiving> var1) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(var0::canTargetEntity).filter(var1).findFirst();
    }

    @Override
    protected int radiusXZ() {
        return 24;
    }

    @Override
    protected int radiusY() {
        return 24;
    }
}

