/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalNearestVillage
extends PathfinderGoal {
    private static final int DISTANCE_THRESHOLD = 10;
    private final EntityCreature mob;
    private final int interval;
    @Nullable
    private BlockPosition wantedPos;

    public PathfinderGoalNearestVillage(EntityCreature var0, int var1) {
        this.mob = var0;
        this.interval = PathfinderGoalNearestVillage.reducedTickDelay(var1);
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        BlockPosition var12;
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.level().isDay()) {
            return false;
        }
        if (this.mob.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        WorldServer var0 = (WorldServer)this.mob.level();
        if (!var0.isCloseToVillage(var12 = this.mob.blockPosition(), 6)) {
            return false;
        }
        Vec3D var2 = LandRandomPos.getPos(this.mob, 15, 7, var1 -> -var0.sectionsToVillage(SectionPosition.of(var1)));
        this.wantedPos = var2 == null ? null : BlockPosition.containing(var2);
        return this.wantedPos != null;
    }

    @Override
    public boolean canContinueToUse() {
        return this.wantedPos != null && !this.mob.getNavigation().isDone() && this.mob.getNavigation().getTargetPos().equals(this.wantedPos);
    }

    @Override
    public void tick() {
        if (this.wantedPos == null) {
            return;
        }
        NavigationAbstract var0 = this.mob.getNavigation();
        if (var0.isDone() && !this.wantedPos.closerToCenterThan(this.mob.position(), 10.0)) {
            Vec3D var1 = Vec3D.atBottomCenterOf(this.wantedPos);
            Vec3D var2 = this.mob.position();
            Vec3D var3 = var2.subtract(var1);
            var1 = var3.scale(0.4).add(var1);
            Vec3D var4 = var1.subtract(var2).normalize().scale(10.0).add(var2);
            BlockPosition var5 = BlockPosition.containing(var4);
            var5 = this.mob.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var5);
            if (!var0.moveTo(var5.getX(), var5.getY(), var5.getZ(), 1.0)) {
                this.moveRandomly();
            }
        }
    }

    private void moveRandomly() {
        RandomSource var0 = this.mob.getRandom();
        BlockPosition var1 = this.mob.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, this.mob.blockPosition().offset(-8 + var0.nextInt(16), 0, -8 + var0.nextInt(16)));
        this.mob.getNavigation().moveTo(var1.getX(), var1.getY(), var1.getZ(), 1.0);
    }
}

