/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalLeapAtTarget
extends PathfinderGoal {
    private final EntityInsentient mob;
    private EntityLiving target;
    private final float yd;

    public PathfinderGoalLeapAtTarget(EntityInsentient var0, float var1) {
        this.mob = var0;
        this.yd = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        double var0 = this.mob.distanceToSqr(this.target);
        if (var0 < 4.0 || var0 > 16.0) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        return this.mob.getRandom().nextInt(PathfinderGoalLeapAtTarget.reducedTickDelay(5)) == 0;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.mob.onGround();
    }

    @Override
    public void start() {
        Vec3D var0 = this.mob.getDeltaMovement();
        Vec3D var1 = new Vec3D(this.target.getX() - this.mob.getX(), 0.0, this.target.getZ() - this.mob.getZ());
        if (var1.lengthSqr() > 1.0E-7) {
            var1 = var1.normalize().scale(0.4).add(var0.scale(0.2));
        }
        this.mob.setDeltaMovement(var1.x, this.yd, var1.z);
    }
}

