/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.level.World;

public class PathfinderGoalBreed
extends PathfinderGoal {
    private static final PathfinderTargetCondition PARTNER_TARGETING = PathfinderTargetCondition.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final EntityAnimal animal;
    private final Class<? extends EntityAnimal> partnerClass;
    protected final World level;
    @Nullable
    protected EntityAnimal partner;
    private int loveTime;
    private final double speedModifier;

    public PathfinderGoalBreed(EntityAnimal var0, double var1) {
        this(var0, var1, var0.getClass());
    }

    public PathfinderGoalBreed(EntityAnimal var0, double var1, Class<? extends EntityAnimal> var3) {
        this.animal = var0;
        this.level = var0.level();
        this.partnerClass = var3;
        this.speedModifier = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        if (!this.animal.isInLove()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    @Override
    public boolean canContinueToUse() {
        return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60;
    }

    @Override
    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    @Override
    public void tick() {
        this.animal.getLookControl().setLookAt(this.partner, 10.0f, this.animal.getMaxHeadXRot());
        this.animal.getNavigation().moveTo(this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr(this.partner) < 9.0) {
            this.breed();
        }
    }

    @Nullable
    private EntityAnimal getFreePartner() {
        List<? extends EntityAnimal> var0 = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, this.animal, this.animal.getBoundingBox().inflate(8.0));
        double var1 = Double.MAX_VALUE;
        EntityAnimal var3 = null;
        for (EntityAnimal entityAnimal : var0) {
            if (!this.animal.canMate(entityAnimal) || !(this.animal.distanceToSqr(entityAnimal) < var1)) continue;
            var3 = entityAnimal;
            var1 = this.animal.distanceToSqr(entityAnimal);
        }
        return var3;
    }

    protected void breed() {
        this.animal.spawnChildFromBreeding((WorldServer)this.level, this.partner);
    }
}

