/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifiable {
    private final AttributeBase attribute;
    private final Map<AttributeModifier.Operation, Set<AttributeModifier>> modifiersByOperation = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<UUID, AttributeModifier> modifierById = new Object2ObjectArrayMap();
    private final Set<AttributeModifier> permanentModifiers = new ObjectArraySet();
    private double baseValue;
    private boolean dirty = true;
    private double cachedValue;
    private final Consumer<AttributeModifiable> onDirty;

    public AttributeModifiable(AttributeBase var0, Consumer<AttributeModifiable> var1) {
        this.attribute = var0;
        this.onDirty = var1;
        this.baseValue = var0.getDefaultValue();
    }

    public AttributeBase getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double var0) {
        if (var0 == this.baseValue) {
            return;
        }
        this.baseValue = var0;
        this.setDirty();
    }

    public Set<AttributeModifier> getModifiers(AttributeModifier.Operation var02) {
        return this.modifiersByOperation.computeIfAbsent(var02, var0 -> Sets.newHashSet());
    }

    public Set<AttributeModifier> getModifiers() {
        return ImmutableSet.copyOf(this.modifierById.values());
    }

    @Nullable
    public AttributeModifier getModifier(UUID var0) {
        return this.modifierById.get(var0);
    }

    public boolean hasModifier(AttributeModifier var0) {
        return this.modifierById.get(var0.getId()) != null;
    }

    private void addModifier(AttributeModifier var0) {
        AttributeModifier var1 = this.modifierById.putIfAbsent(var0.getId(), var0);
        if (var1 != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.getModifiers(var0.getOperation()).add(var0);
        this.setDirty();
    }

    public void addTransientModifier(AttributeModifier var0) {
        this.addModifier(var0);
    }

    public void addPermanentModifier(AttributeModifier var0) {
        this.addModifier(var0);
        this.permanentModifiers.add(var0);
    }

    protected void setDirty() {
        this.dirty = true;
        this.onDirty.accept(this);
    }

    public void removeModifier(AttributeModifier var0) {
        this.getModifiers(var0.getOperation()).remove(var0);
        this.modifierById.remove(var0.getId());
        this.permanentModifiers.remove(var0);
        this.setDirty();
    }

    public void removeModifier(UUID var0) {
        AttributeModifier var1 = this.getModifier(var0);
        if (var1 != null) {
            this.removeModifier(var1);
        }
    }

    public boolean removePermanentModifier(UUID var0) {
        AttributeModifier var1 = this.getModifier(var0);
        if (var1 != null && this.permanentModifiers.contains(var1)) {
            this.removeModifier(var1);
            return true;
        }
        return false;
    }

    public void removeModifiers() {
        for (AttributeModifier var1 : this.getModifiers()) {
            this.removeModifier(var1);
        }
    }

    public double getValue() {
        if (this.dirty) {
            this.cachedValue = this.calculateValue();
            this.dirty = false;
        }
        return this.cachedValue;
    }

    private double calculateValue() {
        double var0 = this.getBaseValue();
        for (AttributeModifier var3 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADDITION)) {
            var0 += var3.getAmount();
        }
        double var2 = var0;
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.MULTIPLY_BASE)) {
            var2 += var0 * var5.getAmount();
        }
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            var2 *= 1.0 + var5.getAmount();
        }
        return this.attribute.sanitizeValue(var2);
    }

    private Collection<AttributeModifier> getModifiersOrEmpty(AttributeModifier.Operation var0) {
        return this.modifiersByOperation.getOrDefault((Object)var0, Collections.emptySet());
    }

    public void replaceFrom(AttributeModifiable var02) {
        this.baseValue = var02.baseValue;
        this.modifierById.clear();
        this.modifierById.putAll(var02.modifierById);
        this.permanentModifiers.clear();
        this.permanentModifiers.addAll(var02.permanentModifiers);
        this.modifiersByOperation.clear();
        var02.modifiersByOperation.forEach((var0, var1) -> this.getModifiers((AttributeModifier.Operation)((Object)var0)).addAll((Collection<AttributeModifier>)var1));
        this.setDirty();
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putString("Name", BuiltInRegistries.ATTRIBUTE.getKey(this.attribute).toString());
        var0.putDouble("Base", this.baseValue);
        if (!this.permanentModifiers.isEmpty()) {
            NBTTagList var1 = new NBTTagList();
            for (AttributeModifier var3 : this.permanentModifiers) {
                var1.add(var3.save());
            }
            var0.put("Modifiers", var1);
        }
        return var0;
    }

    public void load(NBTTagCompound var0) {
        this.baseValue = var0.getDouble("Base");
        if (var0.contains("Modifiers", 9)) {
            NBTTagList var1 = var0.getList("Modifiers", 10);
            for (int var2 = 0; var2 < var1.size(); ++var2) {
                AttributeModifier var3 = AttributeModifier.load(var1.getCompound(var2));
                if (var3 == null) continue;
                this.modifierById.put(var3.getId(), var3);
                this.getModifiers(var3.getOperation()).add(var3);
                this.permanentModifiers.add(var3);
            }
        }
        this.setDirty();
    }
}

