/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class RandomSequences
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long seed;
    private final Map<MinecraftKey, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public RandomSequences(long var0) {
        this.seed = var0;
    }

    public RandomSource get(MinecraftKey var02) {
        final RandomSource var1 = this.sequences.computeIfAbsent(var02, var0 -> new RandomSequence(this.seed, (MinecraftKey)var0)).random();
        return new RandomSource(){

            @Override
            public RandomSource fork() {
                RandomSequences.this.setDirty();
                return var1.fork();
            }

            @Override
            public PositionalRandomFactory forkPositional() {
                RandomSequences.this.setDirty();
                return var1.forkPositional();
            }

            @Override
            public void setSeed(long var0) {
                RandomSequences.this.setDirty();
                var1.setSeed(var0);
            }

            @Override
            public int nextInt() {
                RandomSequences.this.setDirty();
                return var1.nextInt();
            }

            @Override
            public int nextInt(int var0) {
                RandomSequences.this.setDirty();
                return var1.nextInt(var0);
            }

            @Override
            public long nextLong() {
                RandomSequences.this.setDirty();
                return var1.nextLong();
            }

            @Override
            public boolean nextBoolean() {
                RandomSequences.this.setDirty();
                return var1.nextBoolean();
            }

            @Override
            public float nextFloat() {
                RandomSequences.this.setDirty();
                return var1.nextFloat();
            }

            @Override
            public double nextDouble() {
                RandomSequences.this.setDirty();
                return var1.nextDouble();
            }

            @Override
            public double nextGaussian() {
                RandomSequences.this.setDirty();
                return var1.nextGaussian();
            }
        };
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0) {
        this.sequences.forEach((var1, var2) -> var0.put(var1.toString(), (NBTBase)RandomSequence.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var2).result().orElseThrow()));
        return var0;
    }

    public static RandomSequences load(long var0, NBTTagCompound var2) {
        RandomSequences var3 = new RandomSequences(var0);
        Set<String> var4 = var2.getAllKeys();
        for (String var6 : var4) {
            try {
                RandomSequence var7 = (RandomSequence)((Pair)RandomSequence.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var2.get(var6)).result().get()).getFirst();
                var3.sequences.put(new MinecraftKey(var6), var7);
            }
            catch (Exception var7) {
                LOGGER.error("Failed to load random sequence {}", (Object)var6, (Object)var7);
            }
        }
        return var3;
    }
}

