/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;

public interface IInventory
extends Clearable {
    public static final int LARGE_MAX_STACK_SIZE = 64;
    public static final int DEFAULT_DISTANCE_LIMIT = 8;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 64;
    }

    public void setChanged();

    public boolean stillValid(EntityHuman var1);

    default public void startOpen(EntityHuman var0) {
    }

    default public void stopOpen(EntityHuman var0) {
    }

    default public boolean canPlaceItem(int var0, ItemStack var1) {
        return true;
    }

    default public boolean canTakeItem(IInventory var0, int var1, ItemStack var2) {
        return true;
    }

    default public int countItem(Item var0) {
        int var1 = 0;
        for (int var2 = 0; var2 < this.getContainerSize(); ++var2) {
            ItemStack var3 = this.getItem(var2);
            if (!var3.getItem().equals(var0)) continue;
            var1 += var3.getCount();
        }
        return var1;
    }

    default public boolean hasAnyOf(Set<Item> var0) {
        return this.hasAnyMatching(var1 -> !var1.isEmpty() && var0.contains(var1.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> var0) {
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (!var0.test(var2)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(TileEntity var0, EntityHuman var1) {
        return IInventory.stillValidBlockEntity(var0, var1, 8);
    }

    public static boolean stillValidBlockEntity(TileEntity var0, EntityHuman var1, int var2) {
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getBlockPos();
        if (var3 == null) {
            return false;
        }
        if (var3.getBlockEntity(var4) != var0) {
            return false;
        }
        return var1.distanceToSqr((double)var4.getX() + 0.5, (double)var4.getY() + 0.5, (double)var4.getZ() + 0.5) <= (double)(var2 * var2);
    }
}

