/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;

public class ContainerUtil {
    public static ItemStack removeItem(List<ItemStack> var0, int var1, int var2) {
        if (var1 < 0 || var1 >= var0.size() || var0.get(var1).isEmpty() || var2 <= 0) {
            return ItemStack.EMPTY;
        }
        return var0.get(var1).split(var2);
    }

    public static ItemStack takeItem(List<ItemStack> var0, int var1) {
        if (var1 < 0 || var1 >= var0.size()) {
            return ItemStack.EMPTY;
        }
        return var0.set(var1, ItemStack.EMPTY);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1) {
        return ContainerUtil.saveAllItems(var0, var1, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1, boolean var2) {
        NBTTagList var3 = new NBTTagList();
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            ItemStack var5 = var1.get(var4);
            if (var5.isEmpty()) continue;
            NBTTagCompound var6 = new NBTTagCompound();
            var6.putByte("Slot", (byte)var4);
            var5.save(var6);
            var3.add(var6);
        }
        if (!var3.isEmpty() || var2) {
            var0.put("Items", var3);
        }
        return var0;
    }

    public static void loadAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1) {
        NBTTagList var2 = var0.getList("Items", 10);
        for (int var3 = 0; var3 < var2.size(); ++var3) {
            NBTTagCompound var4 = var2.getCompound(var3);
            int var5 = var4.getByte("Slot") & 0xFF;
            if (var5 < 0 || var5 >= var1.size()) continue;
            var1.set(var5, ItemStack.of(var4));
        }
    }

    public static int clearOrCountMatchingItems(IInventory var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        int var4 = 0;
        for (int var5 = 0; var5 < var0.getContainerSize(); ++var5) {
            ItemStack var6 = var0.getItem(var5);
            int var7 = ContainerUtil.clearOrCountMatchingItems(var6, var1, var2 - var4, var3);
            if (var7 > 0 && !var3 && var6.isEmpty()) {
                var0.setItem(var5, ItemStack.EMPTY);
            }
            var4 += var7;
        }
        return var4;
    }

    public static int clearOrCountMatchingItems(ItemStack var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        if (var0.isEmpty() || !var1.test(var0)) {
            return 0;
        }
        if (var3) {
            return var0.getCount();
        }
        int var4 = var2 < 0 ? var0.getCount() : Math.min(var2, var0.getCount());
        var0.shrink(var4);
        return var4;
    }
}

