/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2BooleanFunction;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import org.slf4j.Logger;

public class ThreadedMailbox<T>
implements ProfilerMeasured,
Mailbox<T>,
AutoCloseable,
Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CLOSED_BIT = 1;
    private static final int SCHEDULED_BIT = 2;
    private final AtomicInteger status = new AtomicInteger(0);
    private final PairedQueue<? super T, ? extends Runnable> queue;
    private final Executor dispatcher;
    private final String name;

    public static ThreadedMailbox<Runnable> create(Executor var0, String var1) {
        return new ThreadedMailbox<Runnable>(new PairedQueue.c(new ConcurrentLinkedQueue()), var0, var1);
    }

    public ThreadedMailbox(PairedQueue<? super T, ? extends Runnable> var0, Executor var1, String var2) {
        this.dispatcher = var1;
        this.queue = var0;
        this.name = var2;
        MetricsRegistry.INSTANCE.add(this);
    }

    private boolean setAsScheduled() {
        int var0;
        do {
            if (((var0 = this.status.get()) & 3) == 0) continue;
            return false;
        } while (!this.status.compareAndSet(var0, var0 | 2));
        return true;
    }

    private void setAsIdle() {
        int var0;
        while (!this.status.compareAndSet(var0 = this.status.get(), var0 & 0xFFFFFFFD)) {
        }
    }

    private boolean canBeScheduled() {
        if ((this.status.get() & 1) != 0) {
            return false;
        }
        return !this.queue.isEmpty();
    }

    @Override
    public void close() {
        int var0;
        while (!this.status.compareAndSet(var0 = this.status.get(), var0 | 1)) {
        }
    }

    private boolean shouldProcess() {
        return (this.status.get() & 2) != 0;
    }

    private boolean pollTask() {
        if (!this.shouldProcess()) {
            return false;
        }
        Runnable var0 = this.queue.pop();
        if (var0 == null) {
            return false;
        }
        SystemUtils.wrapThreadWithTaskName(this.name, var0).run();
        return true;
    }

    @Override
    public void run() {
        try {
            this.pollUntil(var0 -> var0 == 0);
        }
        finally {
            this.setAsIdle();
            this.registerForExecution();
        }
    }

    public void runAll() {
        try {
            this.pollUntil(var0 -> true);
        }
        finally {
            this.setAsIdle();
            this.registerForExecution();
        }
    }

    @Override
    public void tell(T var0) {
        this.queue.push(var0);
        this.registerForExecution();
    }

    private void registerForExecution() {
        if (this.canBeScheduled() && this.setAsScheduled()) {
            try {
                this.dispatcher.execute(this);
            }
            catch (RejectedExecutionException var0) {
                try {
                    this.dispatcher.execute(this);
                }
                catch (RejectedExecutionException var1) {
                    LOGGER.error("Cound not schedule mailbox", (Throwable)var1);
                }
            }
        }
    }

    private int pollUntil(Int2BooleanFunction var0) {
        int var1 = 0;
        while (var0.get(var1) && this.pollTask()) {
            ++var1;
        }
        return var1;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasWork() {
        return this.shouldProcess() && !this.queue.isEmpty();
    }

    public String toString() {
        return this.name + " " + this.status.get() + " " + this.queue.isEmpty();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<MetricSampler> profiledMetrics() {
        return ImmutableList.of((Object)MetricSampler.create(this.name + "-queue-size", MetricCategory.MAIL_BOXES, this::size));
    }
}

