/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class BlockEntitySignDoubleSidedEditableTextFix
extends DataConverterNamedEntity {
    public BlockEntitySignDoubleSidedEditableTextFix(Schema var0, String var1, String var2) {
        super(var0, false, var1, DataConverterTypes.BLOCK_ENTITY, var2);
    }

    private static Dynamic<?> fixTag(Dynamic<?> var0) {
        String var1 = "black";
        Dynamic var2 = var0.emptyMap();
        var2 = var2.set("messages", BlockEntitySignDoubleSidedEditableTextFix.getTextList(var0, "Text"));
        var2 = var2.set("filtered_messages", BlockEntitySignDoubleSidedEditableTextFix.getTextList(var0, "FilteredText"));
        Optional var3 = var0.get("Color").result();
        var2 = var2.set("color", var3.isPresent() ? (Dynamic)var3.get() : var2.createString("black"));
        Optional var4 = var0.get("GlowingText").result();
        var2 = var2.set("has_glowing_text", var4.isPresent() ? (Dynamic)var4.get() : var2.createBoolean(false));
        Dynamic var5 = var0.emptyMap();
        Dynamic<?> var6 = BlockEntitySignDoubleSidedEditableTextFix.getEmptyTextList(var0);
        var5 = var5.set("messages", var6);
        var5 = var5.set("filtered_messages", var6);
        var5 = var5.set("color", var5.createString("black"));
        var5 = var5.set("has_glowing_text", var5.createBoolean(false));
        var0 = var0.set("front_text", var2);
        var0 = var0.set("back_text", var5);
        return var0;
    }

    private static <T> Dynamic<T> getTextList(Dynamic<T> var0, String var1) {
        Dynamic var2 = var0.createString(BlockEntitySignDoubleSidedEditableTextFix.getEmptyComponent());
        return var0.createList(Stream.of(var0.get(var1 + "1").result().orElse(var2), var0.get(var1 + "2").result().orElse(var2), var0.get(var1 + "3").result().orElse(var2), var0.get(var1 + "4").result().orElse(var2)));
    }

    private static <T> Dynamic<T> getEmptyTextList(Dynamic<T> var0) {
        Dynamic var1 = var0.createString(BlockEntitySignDoubleSidedEditableTextFix.getEmptyComponent());
        return var0.createList(Stream.of(var1, var1, var1, var1));
    }

    private static String getEmptyComponent() {
        return IChatBaseComponent.ChatSerializer.toJson(CommonComponents.EMPTY);
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), BlockEntitySignDoubleSidedEditableTextFix::fixTag);
    }
}

