/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.Counter;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class Statistic<T>
extends IScoreboardCriteria {
    private final Counter formatter;
    private final T value;
    private final StatisticWrapper<T> type;

    protected Statistic(StatisticWrapper<T> var0, T var1, Counter var2) {
        super(Statistic.buildName(var0, var1));
        this.type = var0;
        this.formatter = var2;
        this.value = var1;
    }

    public static <T> String buildName(StatisticWrapper<T> var0, T var1) {
        return Statistic.locationToKey(BuiltInRegistries.STAT_TYPE.getKey(var0)) + ":" + Statistic.locationToKey(var0.getRegistry().getKey(var1));
    }

    private static <T> String locationToKey(@Nullable MinecraftKey var0) {
        return var0.toString().replace(':', '.');
    }

    public StatisticWrapper<T> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public String format(int var0) {
        return this.formatter.format(var0);
    }

    public boolean equals(Object var0) {
        return this == var0 || var0 instanceof Statistic && Objects.equals(this.getName(), ((Statistic)var0).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Stat{name=" + this.getName() + ", formatter=" + this.formatter + "}";
    }
}

