/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ResourcePackFile
extends ResourcePackAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private final File file;
    @Nullable
    private ZipFile zipFile;
    private boolean failedToLoad;

    public ResourcePackFile(String var0, File var1, boolean var2) {
        super(var0, var2);
        this.file = var1;
    }

    @Nullable
    private ZipFile getOrCreateZipFile() {
        if (this.failedToLoad) {
            return null;
        }
        if (this.zipFile == null) {
            try {
                this.zipFile = new ZipFile(this.file);
            }
            catch (IOException var0) {
                LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)var0);
                this.failedToLoad = true;
                return null;
            }
        }
        return this.zipFile;
    }

    private static String getPathFromLocation(EnumResourcePackType var0, MinecraftKey var1) {
        return String.format(Locale.ROOT, "%s/%s/%s", var0.getDirectory(), var1.getNamespace(), var1.getPath());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var0) {
        return this.getResource(String.join((CharSequence)"/", var0));
    }

    @Override
    public IoSupplier<InputStream> getResource(EnumResourcePackType var0, MinecraftKey var1) {
        return this.getResource(ResourcePackFile.getPathFromLocation(var0, var1));
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String var0) {
        ZipFile var1 = this.getOrCreateZipFile();
        if (var1 == null) {
            return null;
        }
        ZipEntry var2 = var1.getEntry(var0);
        if (var2 == null) {
            return null;
        }
        return IoSupplier.create(var1, var2);
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        ZipFile var1 = this.getOrCreateZipFile();
        if (var1 == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> var2 = var1.entries();
        HashSet var3 = Sets.newHashSet();
        while (var2.hasMoreElements()) {
            ArrayList var6;
            ZipEntry var4 = var2.nextElement();
            String var5 = var4.getName();
            if (!var5.startsWith(var0.getDirectory() + "/") || (var6 = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)var5))).size() <= 1) continue;
            String var7 = (String)var6.get(1);
            if (var7.equals(var7.toLowerCase(Locale.ROOT))) {
                var3.add(var7);
                continue;
            }
            LOGGER.warn("Ignored non-lowercase namespace: {} in {}", (Object)var7, (Object)this.file);
        }
        return var3;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
            this.zipFile = null;
        }
    }

    @Override
    public void listResources(EnumResourcePackType var0, String var1, String var2, IResourcePack.a var3) {
        ZipFile var4 = this.getOrCreateZipFile();
        if (var4 == null) {
            return;
        }
        Enumeration<? extends ZipEntry> var5 = var4.entries();
        String var6 = var0.getDirectory() + "/" + var1 + "/";
        String var7 = var6 + var2 + "/";
        while (var5.hasMoreElements()) {
            String var9;
            ZipEntry var8 = var5.nextElement();
            if (var8.isDirectory() || !(var9 = var8.getName()).startsWith(var7)) continue;
            String var10 = var9.substring(var6.length());
            MinecraftKey var11 = MinecraftKey.tryBuild(var1, var10);
            if (var11 != null) {
                var3.accept(var11, IoSupplier.create(var4, var8));
                continue;
            }
            LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)var1, (Object)var10);
        }
    }
}

