/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.google.common.collect.Lists;
import com.mojang.logging.LogQueues;
import com.mojang.logging.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.GuiStatsComponent;
import net.minecraft.server.gui.PlayerListBox;
import org.slf4j.Logger;

public class ServerGUI
extends JComponent {
    private static final Font MONOSPACED = new Font("Monospaced", 0, 12);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TITLE = "Minecraft server";
    private static final String SHUTDOWN_TITLE = "Minecraft server - shutting down!";
    private final DedicatedServer server;
    private Thread logAppenderThread;
    private final Collection<Runnable> finalizers = Lists.newArrayList();
    final AtomicBoolean isClosing = new AtomicBoolean();

    public static ServerGUI showFrameFor(final DedicatedServer var0) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame var1 = new JFrame(TITLE);
        final ServerGUI var2 = new ServerGUI(var0);
        var1.setDefaultCloseOperation(2);
        var1.add(var2);
        var1.pack();
        var1.setLocationRelativeTo(null);
        var1.setVisible(true);
        var1.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent var02) {
                if (!var2.isClosing.getAndSet(true)) {
                    var1.setTitle(ServerGUI.SHUTDOWN_TITLE);
                    var0.halt(true);
                    var2.runFinalizers();
                }
            }
        });
        var2.addFinalizer(var1::dispose);
        var2.start();
        return var2;
    }

    private ServerGUI(DedicatedServer var0) {
        this.server = var0;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.buildChatPanel(), "Center");
            this.add((Component)this.buildInfoPanel(), "West");
        }
        catch (Exception var1) {
            LOGGER.error("Couldn't build server GUI", (Throwable)var1);
        }
    }

    public void addFinalizer(Runnable var0) {
        this.finalizers.add(var0);
    }

    private JComponent buildInfoPanel() {
        JPanel var0 = new JPanel(new BorderLayout());
        GuiStatsComponent var1 = new GuiStatsComponent(this.server);
        this.finalizers.add(var1::close);
        var0.add((Component)var1, "North");
        var0.add((Component)this.buildPlayerPanel(), "Center");
        var0.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return var0;
    }

    private JComponent buildPlayerPanel() {
        PlayerListBox var0 = new PlayerListBox(this.server);
        JScrollPane var1 = new JScrollPane(var0, 22, 30);
        var1.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return var1;
    }

    private JComponent buildChatPanel() {
        JPanel var0 = new JPanel(new BorderLayout());
        JTextArea var12 = new JTextArea();
        JScrollPane var2 = new JScrollPane(var12, 22, 30);
        var12.setEditable(false);
        var12.setFont(MONOSPACED);
        JTextField var3 = new JTextField();
        var3.addActionListener(var1 -> {
            String var2 = var3.getText().trim();
            if (!var2.isEmpty()) {
                this.server.handleConsoleInput(var2, this.server.createCommandSourceStack());
            }
            var3.setText("");
        });
        var12.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent var0) {
            }
        });
        var0.add((Component)var2, "Center");
        var0.add((Component)var3, "South");
        var0.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.logAppenderThread = new Thread(() -> {
            String var2;
            while ((var2 = LogQueues.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.print(var12, var2, var2);
            }
        });
        this.logAppenderThread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        this.logAppenderThread.setDaemon(true);
        return var0;
    }

    public void start() {
        this.logAppenderThread.start();
    }

    public void close() {
        if (!this.isClosing.getAndSet(true)) {
            this.runFinalizers();
        }
    }

    void runFinalizers() {
        this.finalizers.forEach(Runnable::run);
    }

    public void print(JTextArea var0, JScrollPane var1, String var2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.print(var0, var1, var2));
            return;
        }
        Document var3 = var0.getDocument();
        JScrollBar var4 = var1.getVerticalScrollBar();
        boolean var5 = false;
        if (var1.getViewport().getView() == var0) {
            var5 = (double)var4.getValue() + var4.getSize().getHeight() + (double)(MONOSPACED.getSize() * 4) > (double)var4.getMaximum();
        }
        try {
            var3.insertString(var3.getLength(), var2, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (var5) {
            var4.setValue(Integer.MAX_VALUE);
        }
    }
}

