/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.IntProvider;

public class CommandWeather {
    private static final int DEFAULT_TIME = -1;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("weather").requires(var0 -> var0.hasPermission(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clear").executes(var0 -> CommandWeather.setClear((CommandListenerWrapper)var0.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(var0 -> CommandWeather.setClear((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"duration")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("rain").executes(var0 -> CommandWeather.setRain((CommandListenerWrapper)var0.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(var0 -> CommandWeather.setRain((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"duration")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("thunder").executes(var0 -> CommandWeather.setThunder((CommandListenerWrapper)var0.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(var0 -> CommandWeather.setThunder((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"duration"))))));
    }

    private static int getDuration(CommandListenerWrapper var0, int var1, IntProvider var2) {
        if (var1 == -1) {
            return var2.sample(var0.getLevel().getRandom());
        }
        return var1;
    }

    private static int setClear(CommandListenerWrapper var0, int var1) {
        var0.getLevel().setWeatherParameters(CommandWeather.getDuration(var0, var1, WorldServer.RAIN_DELAY), 0, false, false);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.clear"), true);
        return var1;
    }

    private static int setRain(CommandListenerWrapper var0, int var1) {
        var0.getLevel().setWeatherParameters(0, CommandWeather.getDuration(var0, var1, WorldServer.RAIN_DURATION), true, false);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.rain"), true);
        return var1;
    }

    private static int setThunder(CommandListenerWrapper var0, int var1) {
        var0.getLevel().setWeatherParameters(0, CommandWeather.getDuration(var0, var1, WorldServer.THUNDER_DURATION), true, true);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.thunder"), true);
        return var1;
    }
}

