/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandFill {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.fill.toobig", var0, var1));
    static final ArgumentTileLocation HOLLOW_CORE = new ArgumentTileLocation(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.fill.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("fill").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("from", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("block", ArgumentTile.block(var1)).executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null))).then(net.minecraft.commands.CommandDispatcher.argument("filter", ArgumentBlockPredicate.blockPredicate(var1)).executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter")))))).then(net.minecraft.commands.CommandDispatcher.literal("keep").executes(var02 -> CommandFill.fillBlocks((CommandListenerWrapper)var02.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var02, "block"), Mode.REPLACE, var0 -> var0.getLevel().isEmptyBlock(var0.getPos()))))).then(net.minecraft.commands.CommandDispatcher.literal("outline").executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.OUTLINE, null)))).then(net.minecraft.commands.CommandDispatcher.literal("hollow").executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.HOLLOW, null)))).then(net.minecraft.commands.CommandDispatcher.literal("destroy").executes(var0 -> CommandFill.fillBlocks((CommandListenerWrapper)var0.getSource(), StructureBoundingBox.fromCorners(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.DESTROY, null)))))));
    }

    private static int fillBlocks(CommandListenerWrapper var0, StructureBoundingBox var1, ArgumentTileLocation var2, Mode var3, @Nullable Predicate<ShapeDetectorBlock> var4) throws CommandSyntaxException {
        Object var12;
        int var6;
        int var5 = var1.getXSpan() * var1.getYSpan() * var1.getZSpan();
        if (var5 > (var6 = var0.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var6, (Object)var5);
        }
        ArrayList var7 = Lists.newArrayList();
        WorldServer var8 = var0.getLevel();
        int var9 = 0;
        for (BlockPosition var11 : BlockPosition.betweenClosed(var1.minX(), var1.minY(), var1.minZ(), var1.maxX(), var1.maxY(), var1.maxZ())) {
            if (var4 != null && !var4.test(new ShapeDetectorBlock(var8, var11, true)) || (var12 = var3.filter.filter(var1, var11, var2, var8)) == null) continue;
            TileEntity var13 = var8.getBlockEntity(var11);
            Clearable.tryClear(var13);
            if (!((ArgumentTileLocation)var12).place(var8, var11, 2)) continue;
            var7.add(var11.immutable());
            ++var9;
        }
        for (BlockPosition var11 : var7) {
            var12 = var8.getBlockState(var11).getBlock();
            var8.blockUpdated(var11, (Block)var12);
        }
        if (var9 == 0) {
            throw ERROR_FAILED.create();
        }
        int var10 = var9;
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.fill.success", var10), true);
        return var9;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode REPLACE = new Mode((var0, var1, var2, var3) -> var2);
        public static final /* enum */ Mode OUTLINE = new Mode((var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return null;
        });
        public static final /* enum */ Mode HOLLOW = new Mode((var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return HOLLOW_CORE;
        });
        public static final /* enum */ Mode DESTROY = new Mode((var0, var1, var2, var3) -> {
            var3.destroyBlock(var1, true);
            return var2;
        });
        public final CommandSetBlock.Filter filter;
        private static final /* synthetic */ Mode[] f;

        public static Mode[] values() {
            return (Mode[])f.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private Mode(CommandSetBlock.Filter var2) {
            this.filter = var2;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{REPLACE, OUTLINE, HOLLOW, DESTROY};
        }

        static {
            f = Mode.a();
        }
    }
}

