/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;

public class BossBattleCustom
extends BossBattleServer {
    private final MinecraftKey id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;

    public BossBattleCustom(MinecraftKey var0, IChatBaseComponent var1) {
        super(var1, BossBattle.BarColor.WHITE, BossBattle.BarStyle.PROGRESS);
        this.id = var0;
        this.setProgress(0.0f);
    }

    public MinecraftKey getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(EntityPlayer var0) {
        super.addPlayer(var0);
        this.players.add(var0.getUUID());
    }

    public void addOfflinePlayer(UUID var0) {
        this.players.add(var0);
    }

    @Override
    public void removePlayer(EntityPlayer var0) {
        super.removePlayer(var0);
        this.players.remove(var0.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int var0) {
        this.value = var0;
        this.setProgress(MathHelper.clamp((float)var0 / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int var0) {
        this.max = var0;
        this.setProgress(MathHelper.clamp((float)this.value / (float)var0, 0.0f, 1.0f));
    }

    public final IChatBaseComponent getDisplayName() {
        return ChatComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(var0 -> var0.withColor(this.getColor().getFormatting()).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<EntityPlayer> var0) {
        boolean var5;
        HashSet var1 = Sets.newHashSet();
        HashSet var2 = Sets.newHashSet();
        for (UUID uUID : this.players) {
            var5 = false;
            for (EntityPlayer entityPlayer : var0) {
                if (!entityPlayer.getUUID().equals(uUID)) continue;
                var5 = true;
                break;
            }
            if (var5) continue;
            var1.add(uUID);
        }
        for (EntityPlayer entityPlayer : var0) {
            var5 = false;
            for (UUID uUID : this.players) {
                if (!entityPlayer.getUUID().equals(uUID)) continue;
                var5 = true;
                break;
            }
            if (var5) continue;
            var2.add(entityPlayer);
        }
        for (UUID uUID : var1) {
            for (EntityPlayer var6 : this.getPlayers()) {
                if (!var6.getUUID().equals(uUID)) continue;
                this.removePlayer(var6);
                break;
            }
            this.players.remove(uUID);
        }
        for (EntityPlayer entityPlayer : var2) {
            this.addPlayer(entityPlayer);
        }
        return !var1.isEmpty() || !var2.isEmpty();
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putString("Name", IChatBaseComponent.ChatSerializer.toJson(this.name));
        var0.putBoolean("Visible", this.isVisible());
        var0.putInt("Value", this.value);
        var0.putInt("Max", this.max);
        var0.putString("Color", this.getColor().getName());
        var0.putString("Overlay", this.getOverlay().getName());
        var0.putBoolean("DarkenScreen", this.shouldDarkenScreen());
        var0.putBoolean("PlayBossMusic", this.shouldPlayBossMusic());
        var0.putBoolean("CreateWorldFog", this.shouldCreateWorldFog());
        NBTTagList var1 = new NBTTagList();
        for (UUID var3 : this.players) {
            var1.add(GameProfileSerializer.createUUID(var3));
        }
        var0.put("Players", var1);
        return var0;
    }

    public static BossBattleCustom load(NBTTagCompound var0, MinecraftKey var1) {
        BossBattleCustom var2 = new BossBattleCustom(var1, IChatBaseComponent.ChatSerializer.fromJson(var0.getString("Name")));
        var2.setVisible(var0.getBoolean("Visible"));
        var2.setValue(var0.getInt("Value"));
        var2.setMax(var0.getInt("Max"));
        var2.setColor(BossBattle.BarColor.byName(var0.getString("Color")));
        var2.setOverlay(BossBattle.BarStyle.byName(var0.getString("Overlay")));
        var2.setDarkenScreen(var0.getBoolean("DarkenScreen"));
        var2.setPlayBossMusic(var0.getBoolean("PlayBossMusic"));
        var2.setCreateWorldFog(var0.getBoolean("CreateWorldFog"));
        NBTTagList var3 = var0.getList("Players", 11);
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            var2.addOfflinePlayer(GameProfileSerializer.loadUUID(var3.get(var4)));
        }
        return var2;
    }

    public void onPlayerConnect(EntityPlayer var0) {
        if (this.players.contains(var0.getUUID())) {
            this.addPlayer(var0);
        }
    }

    public void onPlayerDisconnect(EntityPlayer var0) {
        super.removePlayer(var0);
    }
}

