/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;

public class CustomFunctionData {
    private static final IChatBaseComponent NO_RECURSIVE_TRACES = IChatBaseComponent.translatable("commands.debug.function.noRecursion");
    private static final MinecraftKey TICK_FUNCTION_TAG = new MinecraftKey("tick");
    private static final MinecraftKey LOAD_FUNCTION_TAG = new MinecraftKey("load");
    final MinecraftServer server;
    @Nullable
    private ExecutionContext context;
    private List<CustomFunction> ticking = ImmutableList.of();
    private boolean postReload;
    private CustomFunctionManager library;

    public CustomFunctionData(MinecraftServer var0, CustomFunctionManager var1) {
        this.server = var0;
        this.library = var1;
        this.postReload(var1);
    }

    public int getCommandLimit() {
        return this.server.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH);
    }

    public CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.server.getCommands().getDispatcher();
    }

    public void tick() {
        if (this.postReload) {
            this.postReload = false;
            Collection<CustomFunction> var0 = this.library.getTag(LOAD_FUNCTION_TAG);
            this.executeTagFunctions(var0, LOAD_FUNCTION_TAG);
        }
        this.executeTagFunctions(this.ticking, TICK_FUNCTION_TAG);
    }

    private void executeTagFunctions(Collection<CustomFunction> var0, MinecraftKey var1) {
        this.server.getProfiler().push(var1::toString);
        for (CustomFunction var3 : var0) {
            this.execute(var3, this.getGameLoopSender());
        }
        this.server.getProfiler().pop();
    }

    public int execute(CustomFunction var0, CommandListenerWrapper var1) {
        return this.execute(var0, var1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(CustomFunction var0, CommandListenerWrapper var1, @Nullable TraceCallbacks var2) {
        if (this.context != null) {
            if (var2 != null) {
                this.context.reportError(NO_RECURSIVE_TRACES.getString());
                return 0;
            }
            this.context.delayFunctionCall(var0, var1);
            return 0;
        }
        try {
            this.context = new ExecutionContext(var2);
            int n2 = this.context.runTopCommand(var0, var1);
            return n2;
        }
        finally {
            this.context = null;
        }
    }

    public void replaceLibrary(CustomFunctionManager var0) {
        this.library = var0;
        this.postReload(var0);
    }

    private void postReload(CustomFunctionManager var0) {
        this.ticking = ImmutableList.copyOf(var0.getTag(TICK_FUNCTION_TAG));
        this.postReload = true;
    }

    public CommandListenerWrapper getGameLoopSender() {
        return this.server.createCommandSourceStack().withPermission(2).withSuppressedOutput();
    }

    public Optional<CustomFunction> get(MinecraftKey var0) {
        return this.library.getFunction(var0);
    }

    public Collection<CustomFunction> getTag(MinecraftKey var0) {
        return this.library.getTag(var0);
    }

    public Iterable<MinecraftKey> getFunctionNames() {
        return this.library.getFunctions().keySet();
    }

    public Iterable<MinecraftKey> getTagNames() {
        return this.library.getAvailableTags();
    }

    public static interface TraceCallbacks {
        public void onCommand(int var1, String var2);

        public void onReturn(int var1, String var2, int var3);

        public void onError(int var1, String var2);

        public void onCall(int var1, MinecraftKey var2, int var3);
    }

    class ExecutionContext {
        private int depth;
        @Nullable
        private final TraceCallbacks tracer;
        private final Deque<QueuedCommand> commandQueue = Queues.newArrayDeque();
        private final List<QueuedCommand> nestedCalls = Lists.newArrayList();
        boolean abortCurrentDepth = false;

        ExecutionContext(TraceCallbacks var1) {
            this.tracer = var1;
        }

        void delayFunctionCall(CustomFunction var0, CommandListenerWrapper var1) {
            int var2 = CustomFunctionData.this.getCommandLimit();
            CommandListenerWrapper var3 = this.wrapSender(var1);
            if (this.commandQueue.size() + this.nestedCalls.size() < var2) {
                this.nestedCalls.add(new QueuedCommand(var3, this.depth, new CustomFunction.d(var0)));
            }
        }

        private CommandListenerWrapper wrapSender(CommandListenerWrapper var0) {
            IntConsumer var1 = var0.getReturnValueConsumer();
            if (var1 instanceof AbortingReturnValueConsumer) {
                return var0;
            }
            return var0.withReturnValueConsumer(new AbortingReturnValueConsumer(var1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int runTopCommand(CustomFunction var0, CommandListenerWrapper var1) {
            int var2 = CustomFunctionData.this.getCommandLimit();
            CommandListenerWrapper var3 = this.wrapSender(var1);
            int var4 = 0;
            CustomFunction.c[] var5 = var0.getEntries();
            for (int var6 = var5.length - 1; var6 >= 0; --var6) {
                this.commandQueue.push(new QueuedCommand(var3, 0, var5[var6]));
            }
            while (!this.commandQueue.isEmpty()) {
                try {
                    QueuedCommand var6 = this.commandQueue.removeFirst();
                    CustomFunctionData.this.server.getProfiler().push(var6::toString);
                    this.depth = var6.depth;
                    var6.execute(CustomFunctionData.this, this.commandQueue, var2, this.tracer);
                    if (this.abortCurrentDepth) {
                        while (!this.commandQueue.isEmpty() && this.commandQueue.peek().depth >= this.depth) {
                            this.commandQueue.removeFirst();
                        }
                        this.abortCurrentDepth = false;
                    } else if (!this.nestedCalls.isEmpty()) {
                        Lists.reverse(this.nestedCalls).forEach(this.commandQueue::addFirst);
                    }
                    this.nestedCalls.clear();
                }
                finally {
                    CustomFunctionData.this.server.getProfiler().pop();
                }
                if (++var4 < var2) continue;
                return var4;
            }
            return var4;
        }

        public void reportError(String var0) {
            if (this.tracer != null) {
                this.tracer.onError(this.depth, var0);
            }
        }

        class AbortingReturnValueConsumer
        implements IntConsumer {
            private final IntConsumer wrapped;

            AbortingReturnValueConsumer(IntConsumer var1) {
                this.wrapped = var1;
            }

            @Override
            public void accept(int var0) {
                this.wrapped.accept(var0);
                ExecutionContext.this.abortCurrentDepth = true;
            }
        }
    }

    public static class QueuedCommand {
        private final CommandListenerWrapper sender;
        final int depth;
        private final CustomFunction.c entry;

        public QueuedCommand(CommandListenerWrapper var0, int var1, CustomFunction.c var2) {
            this.sender = var0;
            this.depth = var1;
            this.entry = var2;
        }

        public void execute(CustomFunctionData var0, Deque<QueuedCommand> var1, int var2, @Nullable TraceCallbacks var3) {
            block4: {
                try {
                    this.entry.execute(var0, this.sender, var1, var2, this.depth, var3);
                }
                catch (CommandSyntaxException var4) {
                    if (var3 != null) {
                        var3.onError(this.depth, var4.getRawMessage().getString());
                    }
                }
                catch (Exception var4) {
                    if (var3 == null) break block4;
                    var3.onError(this.depth, var4.getMessage());
                }
            }
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

