/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginInListener;

public class PacketLoginInCustomPayload
implements Packet<PacketLoginInListener> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private final int transactionId;
    @Nullable
    private final PacketDataSerializer data;

    public PacketLoginInCustomPayload(int var0, @Nullable PacketDataSerializer var1) {
        this.transactionId = var0;
        this.data = var1;
    }

    public PacketLoginInCustomPayload(PacketDataSerializer var02) {
        this.transactionId = var02.readVarInt();
        this.data = (PacketDataSerializer)((Object)var02.readNullable(var0 -> {
            int var1 = var0.readableBytes();
            if (var1 < 0 || var1 > 0x100000) {
                throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
            }
            return new PacketDataSerializer(var0.readBytes(var1));
        }));
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.transactionId);
        var02.writeNullable(this.data, (var0, var1) -> var0.writeBytes(var1.slice()));
    }

    @Override
    public void handle(PacketLoginInListener var0) {
        var0.handleCustomQueryPacket(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @Nullable
    public PacketDataSerializer getData() {
        return this.data;
    }
}

