/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.item.ItemStack;

public class PacketPlayOutWindowItems
implements Packet<PacketListenerPlayOut> {
    private final int containerId;
    private final int stateId;
    private final List<ItemStack> items;
    private final ItemStack carriedItem;

    public PacketPlayOutWindowItems(int var0, int var1, NonNullList<ItemStack> var2, ItemStack var3) {
        this.containerId = var0;
        this.stateId = var1;
        this.items = NonNullList.withSize(var2.size(), ItemStack.EMPTY);
        for (int var4 = 0; var4 < var2.size(); ++var4) {
            this.items.set(var4, var2.get(var4).copy());
        }
        this.carriedItem = var3.copy();
    }

    public PacketPlayOutWindowItems(PacketDataSerializer var0) {
        this.containerId = var0.readUnsignedByte();
        this.stateId = var0.readVarInt();
        this.items = var0.readCollection(NonNullList::createWithCapacity, PacketDataSerializer::readItem);
        this.carriedItem = var0.readItem();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByte(this.containerId);
        var0.writeVarInt(this.stateId);
        var0.writeCollection(this.items, PacketDataSerializer::writeItem);
        var0.writeItem(this.carriedItem);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleContainerContent(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public int getStateId() {
        return this.stateId;
    }
}

