/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class PacketPlayOutUpdateAttributes
implements Packet<PacketListenerPlayOut> {
    private final int entityId;
    private final List<AttributeSnapshot> attributes;

    public PacketPlayOutUpdateAttributes(int var0, Collection<AttributeModifiable> var1) {
        this.entityId = var0;
        this.attributes = Lists.newArrayList();
        for (AttributeModifiable var3 : var1) {
            this.attributes.add(new AttributeSnapshot(var3.getAttribute(), var3.getBaseValue(), var3.getModifiers()));
        }
    }

    public PacketPlayOutUpdateAttributes(PacketDataSerializer var0) {
        this.entityId = var0.readVarInt();
        this.attributes = var0.readList(var02 -> {
            MinecraftKey var1 = var02.readResourceLocation();
            AttributeBase var2 = BuiltInRegistries.ATTRIBUTE.get(var1);
            double var3 = var02.readDouble();
            List<AttributeModifier> var5 = var02.readList(var0 -> new AttributeModifier(var0.readUUID(), "Unknown synced attribute modifier", var0.readDouble(), AttributeModifier.Operation.fromValue(var0.readByte())));
            return new AttributeSnapshot(var2, var3, var5);
        });
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entityId);
        var0.writeCollection(this.attributes, (var02, var12) -> {
            var02.writeResourceLocation(BuiltInRegistries.ATTRIBUTE.getKey(var12.getAttribute()));
            var02.writeDouble(var12.getBase());
            var02.writeCollection(var12.getModifiers(), (var0, var1) -> {
                var0.writeUUID(var1.getId());
                var0.writeDouble(var1.getAmount());
                var0.writeByte(var1.getOperation().toValue());
            });
        });
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateAttributes(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<AttributeSnapshot> getValues() {
        return this.attributes;
    }

    public static class AttributeSnapshot {
        private final AttributeBase attribute;
        private final double base;
        private final Collection<AttributeModifier> modifiers;

        public AttributeSnapshot(AttributeBase var0, double var1, Collection<AttributeModifier> var3) {
            this.attribute = var0;
            this.base = var1;
            this.modifiers = var3;
        }

        public AttributeBase getAttribute() {
            return this.attribute;
        }

        public double getBase() {
            return this.base;
        }

        public Collection<AttributeModifier> getModifiers() {
            return this.modifiers;
        }
    }
}

