/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public class PacketPlayInBEdit
implements Packet<PacketListenerPlayIn> {
    public static final int MAX_BYTES_PER_CHAR = 4;
    private static final int TITLE_MAX_CHARS = 128;
    private static final int PAGE_MAX_CHARS = 8192;
    private static final int MAX_PAGES_COUNT = 200;
    private final int slot;
    private final List<String> pages;
    private final Optional<String> title;

    public PacketPlayInBEdit(int var0, List<String> var1, Optional<String> var2) {
        this.slot = var0;
        this.pages = ImmutableList.copyOf(var1);
        this.title = var2;
    }

    public PacketPlayInBEdit(PacketDataSerializer var02) {
        this.slot = var02.readVarInt();
        this.pages = var02.readCollection(PacketDataSerializer.limitValue(Lists::newArrayListWithCapacity, 200), var0 -> var0.readUtf(8192));
        this.title = var02.readOptional(var0 -> var0.readUtf(128));
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.slot);
        var02.writeCollection(this.pages, (var0, var1) -> var0.writeUtf((String)var1, 8192));
        var02.writeOptional(this.title, (var0, var1) -> var0.writeUtf((String)var1, 128));
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleEditBook(this);
    }

    public List<String> getPages() {
        return this.pages;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public int getSlot() {
        return this.slot;
    }
}

