/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public record ClientboundDamageEventPacket(int entityId, int sourceTypeId, int sourceCauseId, int sourceDirectId, Optional<Vec3D> sourcePosition) implements Packet<PacketListenerPlayOut>
{
    public ClientboundDamageEventPacket(Entity var0, DamageSource var1) {
        this(var0.getId(), var0.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getId(var1.type()), var1.getEntity() != null ? var1.getEntity().getId() : -1, var1.getDirectEntity() != null ? var1.getDirectEntity().getId() : -1, Optional.ofNullable(var1.sourcePositionRaw()));
    }

    public ClientboundDamageEventPacket(PacketDataSerializer var02) {
        this(var02.readVarInt(), var02.readVarInt(), ClientboundDamageEventPacket.readOptionalEntityId(var02), ClientboundDamageEventPacket.readOptionalEntityId(var02), var02.readOptional(var0 -> new Vec3D(var0.readDouble(), var0.readDouble(), var0.readDouble())));
    }

    private static void writeOptionalEntityId(PacketDataSerializer var0, int var1) {
        var0.writeVarInt(var1 + 1);
    }

    private static int readOptionalEntityId(PacketDataSerializer var0) {
        return var0.readVarInt() - 1;
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.entityId);
        var02.writeVarInt(this.sourceTypeId);
        ClientboundDamageEventPacket.writeOptionalEntityId(var02, this.sourceCauseId);
        ClientboundDamageEventPacket.writeOptionalEntityId(var02, this.sourceDirectId);
        var02.writeOptional(this.sourcePosition, (var0, var1) -> {
            var0.writeDouble(var1.x());
            var0.writeDouble(var1.y());
            var0.writeDouble(var1.z());
        });
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleDamageEvent(this);
    }

    public DamageSource getSource(World var0) {
        Holder var1 = var0.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(this.sourceTypeId).get();
        if (this.sourcePosition.isPresent()) {
            return new DamageSource((Holder<DamageType>)var1, this.sourcePosition.get());
        }
        Entity var2 = var0.getEntity(this.sourceCauseId);
        Entity var3 = var0.getEntity(this.sourceDirectId);
        return new DamageSource(var1, var3, var2);
    }
}

