/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;

public class ScoreContents
implements ComponentContents {
    private static final String SCORER_PLACEHOLDER = "*";
    private final String name;
    @Nullable
    private final EntitySelector selector;
    private final String objective;

    @Nullable
    private static EntitySelector parseSelector(String var0) {
        try {
            return new ArgumentParserSelector(new StringReader(var0)).parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ScoreContents(String var0, String var1) {
        this.name = var0;
        this.selector = ScoreContents.parseSelector(var0);
        this.objective = var1;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public String getObjective() {
        return this.objective;
    }

    private String findTargetName(CommandListenerWrapper var0) throws CommandSyntaxException {
        List<? extends Entity> var1;
        if (this.selector != null && !(var1 = this.selector.findEntities(var0)).isEmpty()) {
            if (var1.size() != 1) {
                throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return var1.get(0).getScoreboardName();
        }
        return this.name;
    }

    private String getScore(String var0, CommandListenerWrapper var1) {
        ScoreboardObjective var4;
        ScoreboardServer var3;
        MinecraftServer var2 = var1.getServer();
        if (var2 != null && (var3 = var2.getScoreboard()).hasPlayerScore(var0, var4 = var3.getObjective(this.objective))) {
            ScoreboardScore var5 = var3.getOrCreatePlayerScore(var0, var4);
            return Integer.toString(var5.getScore());
        }
        return "";
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null) {
            return IChatBaseComponent.empty();
        }
        String var3 = this.findTargetName(var0);
        String var4 = var1 != null && var3.equals(SCORER_PLACEHOLDER) ? var1.getScoreboardName() : var3;
        return IChatBaseComponent.literal(this.getScore(var4, var0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ScoreContents)) return false;
        ScoreContents var1 = (ScoreContents)var0;
        if (!this.name.equals(var1.name)) return false;
        if (!this.objective.equals(var1.objective)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.name.hashCode();
        var0 = 31 * var0 + this.objective.hashCode();
        return var0;
    }

    public String toString() {
        return "score{name='" + this.name + "', objective='" + this.objective + "'}";
    }
}

