/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class ChatHoverable {
    static final Logger LOGGER = LogUtils.getLogger();
    private final EnumHoverAction<?> action;
    private final Object value;

    public <T> ChatHoverable(EnumHoverAction<T> var0, T var1) {
        this.action = var0;
        this.value = var1;
    }

    public EnumHoverAction<?> getAction() {
        return this.action;
    }

    @Nullable
    public <T> T getValue(EnumHoverAction<T> var0) {
        if (this.action == var0) {
            return var0.cast(this.value);
        }
        return null;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        ChatHoverable var1 = (ChatHoverable)var0;
        return this.action == var1.action && Objects.equals(this.value, var1.value);
    }

    public String toString() {
        return "HoverEvent{action=" + this.action + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int var0 = this.action.hashCode();
        var0 = 31 * var0 + (this.value != null ? this.value.hashCode() : 0);
        return var0;
    }

    @Nullable
    public static ChatHoverable deserialize(JsonObject var0) {
        String var1 = ChatDeserializer.getAsString(var0, "action", null);
        if (var1 == null) {
            return null;
        }
        EnumHoverAction<?> var2 = EnumHoverAction.getByName(var1);
        if (var2 == null) {
            return null;
        }
        JsonElement var3 = var0.get("contents");
        if (var3 != null) {
            return var2.deserialize(var3);
        }
        IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.fromJson(var0.get("value"));
        if (var4 != null) {
            return var2.deserializeFromLegacy(var4);
        }
        return null;
    }

    public JsonObject serialize() {
        JsonObject var0 = new JsonObject();
        var0.addProperty("action", this.action.getName());
        var0.add("contents", this.action.serializeArg(this.value));
        return var0;
    }

    public static class EnumHoverAction<T> {
        public static final EnumHoverAction<IChatBaseComponent> SHOW_TEXT = new EnumHoverAction<IChatBaseComponent>("show_text", true, IChatBaseComponent.ChatSerializer::fromJson, IChatBaseComponent.ChatSerializer::toJsonTree, Function.identity());
        public static final EnumHoverAction<c> SHOW_ITEM = new EnumHoverAction<c>("show_item", true, c::create, c::serialize, c::create);
        public static final EnumHoverAction<b> SHOW_ENTITY = new EnumHoverAction<b>("show_entity", true, b::create, b::serialize, b::create);
        private static final Map<String, EnumHoverAction<?>> LOOKUP = (Map)Stream.of(SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY).collect(ImmutableMap.toImmutableMap(EnumHoverAction::getName, var0 -> var0));
        private final String name;
        private final boolean allowFromServer;
        private final Function<JsonElement, T> argDeserializer;
        private final Function<T, JsonElement> argSerializer;
        private final Function<IChatBaseComponent, T> legacyArgDeserializer;

        public EnumHoverAction(String var0, boolean var1, Function<JsonElement, T> var2, Function<T, JsonElement> var3, Function<IChatBaseComponent, T> var4) {
            this.name = var0;
            this.allowFromServer = var1;
            this.argDeserializer = var2;
            this.argSerializer = var3;
            this.legacyArgDeserializer = var4;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static EnumHoverAction<?> getByName(String var0) {
            return LOOKUP.get(var0);
        }

        T cast(Object var0) {
            return (T)var0;
        }

        @Nullable
        public ChatHoverable deserialize(JsonElement var0) {
            T var1 = this.argDeserializer.apply(var0);
            if (var1 == null) {
                return null;
            }
            return new ChatHoverable(this, var1);
        }

        @Nullable
        public ChatHoverable deserializeFromLegacy(IChatBaseComponent var0) {
            T var1 = this.legacyArgDeserializer.apply(var0);
            if (var1 == null) {
                return null;
            }
            return new ChatHoverable(this, var1);
        }

        public JsonElement serializeArg(Object var0) {
            return this.argSerializer.apply(this.cast(var0));
        }

        public String toString() {
            return "<action " + this.name + ">";
        }
    }

    public static class c {
        private final Item item;
        private final int count;
        @Nullable
        private final NBTTagCompound tag;
        @Nullable
        private ItemStack itemStack;

        c(Item var0, int var1, @Nullable NBTTagCompound var2) {
            this.item = var0;
            this.count = var1;
            this.tag = var2;
        }

        public c(ItemStack var0) {
            this(var0.getItem(), var0.getCount(), var0.getTag() != null ? var0.getTag().copy() : null);
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            c var1 = (c)var0;
            return this.count == var1.count && this.item.equals(var1.item) && Objects.equals(this.tag, var1.tag);
        }

        public int hashCode() {
            int var0 = this.item.hashCode();
            var0 = 31 * var0 + this.count;
            var0 = 31 * var0 + (this.tag != null ? this.tag.hashCode() : 0);
            return var0;
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count);
                if (this.tag != null) {
                    this.itemStack.setTag(this.tag);
                }
            }
            return this.itemStack;
        }

        private static c create(JsonElement var0) {
            if (var0.isJsonPrimitive()) {
                return new c(BuiltInRegistries.ITEM.get(new MinecraftKey(var0.getAsString())), 1, null);
            }
            JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "item");
            Item var2 = BuiltInRegistries.ITEM.get(new MinecraftKey(ChatDeserializer.getAsString(var1, "id")));
            int var3 = ChatDeserializer.getAsInt(var1, "count", 1);
            if (var1.has("tag")) {
                String var4 = ChatDeserializer.getAsString(var1, "tag");
                try {
                    NBTTagCompound var5 = MojangsonParser.parseTag(var4);
                    return new c(var2, var3, var5);
                }
                catch (CommandSyntaxException var5) {
                    LOGGER.warn("Failed to parse tag: {}", (Object)var4, (Object)var5);
                }
            }
            return new c(var2, var3, null);
        }

        @Nullable
        private static c create(IChatBaseComponent var0) {
            try {
                NBTTagCompound var1 = MojangsonParser.parseTag(var0.getString());
                return new c(ItemStack.of(var1));
            }
            catch (CommandSyntaxException var1) {
                LOGGER.warn("Failed to parse item tag: {}", (Object)var0, (Object)var1);
                return null;
            }
        }

        private JsonElement serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("id", BuiltInRegistries.ITEM.getKey(this.item).toString());
            if (this.count != 1) {
                var0.addProperty("count", (Number)this.count);
            }
            if (this.tag != null) {
                var0.addProperty("tag", this.tag.toString());
            }
            return var0;
        }
    }

    public static class b {
        public final EntityTypes<?> type;
        public final UUID id;
        @Nullable
        public final IChatBaseComponent name;
        @Nullable
        private List<IChatBaseComponent> linesCache;

        public b(EntityTypes<?> var0, UUID var1, @Nullable IChatBaseComponent var2) {
            this.type = var0;
            this.id = var1;
            this.name = var2;
        }

        @Nullable
        public static b create(JsonElement var0) {
            if (!var0.isJsonObject()) {
                return null;
            }
            JsonObject var1 = var0.getAsJsonObject();
            EntityTypes<?> var2 = BuiltInRegistries.ENTITY_TYPE.get(new MinecraftKey(ChatDeserializer.getAsString(var1, "type")));
            UUID var3 = UUID.fromString(ChatDeserializer.getAsString(var1, "id"));
            IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.fromJson(var1.get("name"));
            return new b(var2, var3, var4);
        }

        @Nullable
        public static b create(IChatBaseComponent var0) {
            try {
                NBTTagCompound var1 = MojangsonParser.parseTag(var0.getString());
                IChatMutableComponent var2 = IChatBaseComponent.ChatSerializer.fromJson(var1.getString("name"));
                EntityTypes<?> var3 = BuiltInRegistries.ENTITY_TYPE.get(new MinecraftKey(var1.getString("type")));
                UUID var4 = UUID.fromString(var1.getString("id"));
                return new b(var3, var4, var2);
            }
            catch (Exception var1) {
                return null;
            }
        }

        public JsonElement serialize() {
            JsonObject var0 = new JsonObject();
            var0.addProperty("type", BuiltInRegistries.ENTITY_TYPE.getKey(this.type).toString());
            var0.addProperty("id", this.id.toString());
            if (this.name != null) {
                var0.add("name", IChatBaseComponent.ChatSerializer.toJsonTree(this.name));
            }
            return var0;
        }

        public List<IChatBaseComponent> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = Lists.newArrayList();
                if (this.name != null) {
                    this.linesCache.add(this.name);
                }
                this.linesCache.add(IChatBaseComponent.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(IChatBaseComponent.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return this.type.equals(var1.type) && this.id.equals(var1.id) && Objects.equals(this.name, var1.name);
        }

        public int hashCode() {
            int var0 = this.type.hashCode();
            var0 = 31 * var0 + this.id.hashCode();
            var0 = 31 * var0 + (this.name != null ? this.name.hashCode() : 0);
            return var0;
        }
    }
}

