/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagDouble
extends NBTNumber {
    private static final int SELF_SIZE_IN_BYTES = 16;
    public static final NBTTagDouble ZERO = new NBTTagDouble(0.0);
    public static final NBTTagType<NBTTagDouble> TYPE = new NBTTagType.a<NBTTagDouble>(){

        @Override
        public NBTTagDouble load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBytes(16L);
            return NBTTagDouble.valueOf(var0.readDouble());
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            return var1.visit(var0.readDouble());
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public String getName() {
            return "DOUBLE";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Double";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private final double data;

    private NBTTagDouble(double var0) {
        this.data = var0;
    }

    public static NBTTagDouble valueOf(double var0) {
        if (var0 == 0.0) {
            return ZERO;
        }
        return new NBTTagDouble(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeDouble(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 16;
    }

    @Override
    public byte getId() {
        return 6;
    }

    public NBTTagType<NBTTagDouble> getType() {
        return TYPE;
    }

    @Override
    public NBTTagDouble copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagDouble && this.data == ((NBTTagDouble)var0).data;
    }

    public int hashCode() {
        long var0 = Double.doubleToLongBits(this.data);
        return (int)(var0 ^ var0 >>> 32);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitDouble(this);
    }

    @Override
    public long getAsLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    public int getAsInt() {
        return MathHelper.floor(this.data);
    }

    @Override
    public short getAsShort() {
        return (short)(MathHelper.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(MathHelper.floor(this.data) & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return (float)this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

