/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.commons.io.IOUtils;

public class GameTestHarnessTestCommand {
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    private static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("test").then(net.minecraft.commands.CommandDispatcher.literal("runthis").executes(var0 -> GameTestHarnessTestCommand.runNearbyTest((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("runthese").executes(var0 -> GameTestHarnessTestCommand.runAllNearbyTests((CommandListenerWrapper)var0.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("runfailed").executes(var0 -> GameTestHarnessTestCommand.runLastFailedTests((CommandListenerWrapper)var0.getSource(), false, 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("onlyRequiredTests", BoolArgumentType.bool()).executes(var0 -> GameTestHarnessTestCommand.runLastFailedTests((CommandListenerWrapper)var0.getSource(), BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests"), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runLastFailedTests((CommandListenerWrapper)var0.getSource(), BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.argument("testsPerRow", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runLastFailedTests((CommandListenerWrapper)var0.getSource(), BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"testsPerRow")))))))).then(net.minecraft.commands.CommandDispatcher.literal("run").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("testName", GameTestHarnessTestFunctionArgument.testFunctionArgument()).executes(var0 -> GameTestHarnessTestCommand.runTest((CommandListenerWrapper)var0.getSource(), GameTestHarnessTestFunctionArgument.getTestFunction((CommandContext<CommandListenerWrapper>)var0, "testName"), 0))).then(net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runTest((CommandListenerWrapper)var0.getSource(), GameTestHarnessTestFunctionArgument.getTestFunction((CommandContext<CommandListenerWrapper>)var0, "testName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("runall").executes(var0 -> GameTestHarnessTestCommand.runAllTests((CommandListenerWrapper)var0.getSource(), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("testClassName", GameTestHarnessTestClassArgument.testClassName()).executes(var0 -> GameTestHarnessTestCommand.runAllTestsInClass((CommandListenerWrapper)var0.getSource(), GameTestHarnessTestClassArgument.getTestClassName((CommandContext<CommandListenerWrapper>)var0, "testClassName"), 0, 8))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runAllTestsInClass((CommandListenerWrapper)var0.getSource(), GameTestHarnessTestClassArgument.getTestClassName((CommandContext<CommandListenerWrapper>)var0, "testClassName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.argument("testsPerRow", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runAllTestsInClass((CommandListenerWrapper)var0.getSource(), GameTestHarnessTestClassArgument.getTestClassName((CommandContext<CommandListenerWrapper>)var0, "testClassName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"testsPerRow"))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runAllTests((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), 8))).then(net.minecraft.commands.CommandDispatcher.argument("testsPerRow", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.runAllTests((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"testsPerRow"))))))).then(net.minecraft.commands.CommandDispatcher.literal("export").then(net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.exportTestStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.literal("exportthis").executes(var0 -> GameTestHarnessTestCommand.exportNearestTestStructure((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("import").then(net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.importTestStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pos").executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), "pos"))).then(net.minecraft.commands.CommandDispatcher.argument("var", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"var")))))).then(net.minecraft.commands.CommandDispatcher.literal("create").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("width", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width")))).then(net.minecraft.commands.CommandDispatcher.argument("height", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.argument("depth", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"height"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"depth"))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clearall").executes(var0 -> GameTestHarnessTestCommand.clearAllTests((CommandListenerWrapper)var0.getSource(), 200))).then(net.minecraft.commands.CommandDispatcher.argument("radius", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.clearAllTests((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"radius"))))));
    }

    private static int createNewStructure(CommandListenerWrapper var0, String var1, int var2, int var3, int var4) {
        if (var2 > 48 || var3 > 48 || var4 > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        WorldServer var5 = var0.getLevel();
        BlockPosition var6 = BlockPosition.containing(var0.getPosition());
        BlockPosition var7 = new BlockPosition(var6.getX(), var0.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var6).getY(), var6.getZ() + 3);
        GameTestHarnessStructures.createNewEmptyStructureBlock(var1.toLowerCase(), var7, new BaseBlockPosition(var2, var3, var4), EnumBlockRotation.NONE, var5);
        for (int var8 = 0; var8 < var2; ++var8) {
            for (int var9 = 0; var9 < var4; ++var9) {
                BlockPosition var10 = new BlockPosition(var7.getX() + var8, var7.getY() + 1, var7.getZ() + var9);
                Block var11 = Blocks.POLISHED_ANDESITE;
                ArgumentTileLocation var12 = new ArgumentTileLocation(var11.defaultBlockState(), Collections.emptySet(), null);
                var12.place(var5, var10, 2);
            }
        }
        GameTestHarnessStructures.addCommandBlockAndButtonToStartTest(var7, new BlockPosition(1, 0, -1), EnumBlockRotation.NONE, var5);
        return 0;
    }

    private static int showPos(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        WorldServer var4;
        MovingObjectPositionBlock var2 = (MovingObjectPositionBlock)var0.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPosition var3 = var2.getBlockPos();
        Optional<BlockPosition> var5 = GameTestHarnessStructures.findStructureBlockContainingPos(var3, 15, var4 = var0.getLevel());
        if (!var5.isPresent()) {
            var5 = GameTestHarnessStructures.findStructureBlockContainingPos(var3, 200, var4);
        }
        if (!var5.isPresent()) {
            var0.sendFailure(IChatBaseComponent.literal("Can't find a structure block that contains the targeted pos " + var3));
            return 0;
        }
        TileEntityStructure var6 = (TileEntityStructure)var4.getBlockEntity(var5.get());
        BlockPosition var7 = var3.subtract(var5.get());
        String var8 = var7.getX() + ", " + var7.getY() + ", " + var7.getZ();
        String var9 = var6.getStructurePath();
        IChatMutableComponent var10 = IChatBaseComponent.literal(var8).setStyle(ChatModifier.EMPTY.withBold(true).withColor(EnumChatFormat.GREEN).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.literal("Click to copy to clipboard"))).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.COPY_TO_CLIPBOARD, "final BlockPos " + var1 + " = new BlockPos(" + var8 + ");")));
        var0.sendSuccess(() -> IChatBaseComponent.literal("Position relative to " + var9 + ": ").append(var10), false);
        PacketDebug.sendGameTestAddMarker(var4, new BlockPosition(var3), var8, -2147418368, 10000);
        return 1;
    }

    private static int runNearbyTest(CommandListenerWrapper var0) {
        WorldServer var2;
        BlockPosition var1 = BlockPosition.containing(var0.getPosition());
        BlockPosition var3 = GameTestHarnessStructures.findNearestStructureBlock(var1, 15, var2 = var0.getLevel());
        if (var3 == null) {
            GameTestHarnessTestCommand.say(var2, "Couldn't find any structure block within 15 radius", EnumChatFormat.RED);
            return 0;
        }
        GameTestHarnessRunner.clearMarkers(var2);
        GameTestHarnessTestCommand.runTest(var2, var3, null);
        return 1;
    }

    private static int runAllNearbyTests(CommandListenerWrapper var0) {
        WorldServer var22;
        BlockPosition var1 = BlockPosition.containing(var0.getPosition());
        Collection<BlockPosition> var3 = GameTestHarnessStructures.findStructureBlocks(var1, 200, var22 = var0.getLevel());
        if (var3.isEmpty()) {
            GameTestHarnessTestCommand.say(var22, "Couldn't find any structure blocks within 200 block radius", EnumChatFormat.RED);
            return 1;
        }
        GameTestHarnessRunner.clearMarkers(var22);
        GameTestHarnessTestCommand.say(var0, "Running " + var3.size() + " tests...");
        GameTestHarnessCollector var4 = new GameTestHarnessCollector();
        var3.forEach(var2 -> GameTestHarnessTestCommand.runTest(var22, var2, var4));
        return 1;
    }

    private static void runTest(WorldServer var0, BlockPosition var1, @Nullable GameTestHarnessCollector var2) {
        TileEntityStructure var3 = (TileEntityStructure)var0.getBlockEntity(var1);
        String var4 = var3.getStructurePath();
        GameTestHarnessTestFunction var5 = GameTestHarnessRegistry.getTestFunction(var4);
        GameTestHarnessInfo var6 = new GameTestHarnessInfo(var5, var3.getRotation(), var0);
        if (var2 != null) {
            var2.addTestToTrack(var6);
            var6.addListener(new a(var0, var2));
        }
        GameTestHarnessTestCommand.runTestPreparation(var5, var0);
        AxisAlignedBB var7 = GameTestHarnessStructures.getStructureBounds(var3);
        BlockPosition var8 = BlockPosition.containing(var7.minX, var7.minY, var7.minZ);
        GameTestHarnessRunner.runTest(var6, var8, GameTestHarnessTicker.SINGLETON);
    }

    static void showTestSummaryIfAllDone(WorldServer var0, GameTestHarnessCollector var1) {
        if (var1.isDone()) {
            GameTestHarnessTestCommand.say(var0, "GameTest done! " + var1.getTotalCount() + " tests were run", EnumChatFormat.WHITE);
            if (var1.hasFailedRequired()) {
                GameTestHarnessTestCommand.say(var0, var1.getFailedRequiredCount() + " required tests failed :(", EnumChatFormat.RED);
            } else {
                GameTestHarnessTestCommand.say(var0, "All required tests passed :)", EnumChatFormat.GREEN);
            }
            if (var1.hasFailedOptional()) {
                GameTestHarnessTestCommand.say(var0, var1.getFailedOptionalCount() + " optional tests failed", EnumChatFormat.GRAY);
            }
        }
    }

    private static int clearAllTests(CommandListenerWrapper var0, int var1) {
        WorldServer var2 = var0.getLevel();
        GameTestHarnessRunner.clearMarkers(var2);
        BlockPosition var3 = BlockPosition.containing(var0.getPosition().x, var0.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, BlockPosition.containing(var0.getPosition())).getY(), var0.getPosition().z);
        GameTestHarnessRunner.clearAllTests(var2, var3, GameTestHarnessTicker.SINGLETON, MathHelper.clamp(var1, 0, 1024));
        return 1;
    }

    private static int runTest(CommandListenerWrapper var0, GameTestHarnessTestFunction var1, int var2) {
        WorldServer var3 = var0.getLevel();
        BlockPosition var4 = BlockPosition.containing(var0.getPosition());
        int var5 = var0.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var4).getY();
        BlockPosition var6 = new BlockPosition(var4.getX(), var5, var4.getZ() + 3);
        GameTestHarnessRunner.clearMarkers(var3);
        GameTestHarnessTestCommand.runTestPreparation(var1, var3);
        EnumBlockRotation var7 = GameTestHarnessStructures.getRotationForRotationSteps(var2);
        GameTestHarnessInfo var8 = new GameTestHarnessInfo(var1, var7, var3);
        GameTestHarnessRunner.runTest(var8, var6, GameTestHarnessTicker.SINGLETON);
        return 1;
    }

    private static void runTestPreparation(GameTestHarnessTestFunction var0, WorldServer var1) {
        Consumer<WorldServer> var2 = GameTestHarnessRegistry.getBeforeBatchFunction(var0.getBatchName());
        if (var2 != null) {
            var2.accept(var1);
        }
    }

    private static int runAllTests(CommandListenerWrapper var0, int var1, int var2) {
        GameTestHarnessRunner.clearMarkers(var0.getLevel());
        Collection<GameTestHarnessTestFunction> var3 = GameTestHarnessRegistry.getAllTestFunctions();
        GameTestHarnessTestCommand.say(var0, "Running all " + var3.size() + " tests...");
        GameTestHarnessRegistry.forgetFailedTests();
        GameTestHarnessTestCommand.runTests(var0, var3, var1, var2);
        return 1;
    }

    private static int runAllTestsInClass(CommandListenerWrapper var0, String var1, int var2, int var3) {
        Collection<GameTestHarnessTestFunction> var4 = GameTestHarnessRegistry.getTestFunctionsForClassName(var1);
        GameTestHarnessRunner.clearMarkers(var0.getLevel());
        GameTestHarnessTestCommand.say(var0, "Running " + var4.size() + " tests from " + var1 + "...");
        GameTestHarnessRegistry.forgetFailedTests();
        GameTestHarnessTestCommand.runTests(var0, var4, var2, var3);
        return 1;
    }

    private static int runLastFailedTests(CommandListenerWrapper var0, boolean var1, int var2, int var3) {
        Collection var4 = var1 ? (Collection)GameTestHarnessRegistry.getLastFailedTests().stream().filter(GameTestHarnessTestFunction::isRequired).collect(Collectors.toList()) : GameTestHarnessRegistry.getLastFailedTests();
        if (var4.isEmpty()) {
            GameTestHarnessTestCommand.say(var0, "No failed tests to rerun");
            return 0;
        }
        GameTestHarnessRunner.clearMarkers(var0.getLevel());
        GameTestHarnessTestCommand.say(var0, "Rerunning " + var4.size() + " failed tests (" + (var1 ? "only required tests" : "including optional tests") + ")");
        GameTestHarnessTestCommand.runTests(var0, var4, var2, var3);
        return 1;
    }

    private static void runTests(CommandListenerWrapper var02, Collection<GameTestHarnessTestFunction> var1, int var2, int var3) {
        BlockPosition var4 = BlockPosition.containing(var02.getPosition());
        BlockPosition var5 = new BlockPosition(var4.getX(), var02.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var4).getY(), var4.getZ() + 3);
        WorldServer var6 = var02.getLevel();
        EnumBlockRotation var7 = GameTestHarnessStructures.getRotationForRotationSteps(var2);
        Collection<GameTestHarnessInfo> var8 = GameTestHarnessRunner.runTests(var1, var5, var7, var6, GameTestHarnessTicker.SINGLETON, var3);
        GameTestHarnessCollector var9 = new GameTestHarnessCollector(var8);
        var9.addListener(new a(var6, var9));
        var9.addFailureListener(var0 -> GameTestHarnessRegistry.rememberFailedTest(var0.getTestFunction()));
    }

    private static void say(CommandListenerWrapper var0, String var1) {
        var0.sendSuccess(() -> IChatBaseComponent.literal(var1), false);
    }

    private static int exportNearestTestStructure(CommandListenerWrapper var0) {
        WorldServer var2;
        BlockPosition var1 = BlockPosition.containing(var0.getPosition());
        BlockPosition var3 = GameTestHarnessStructures.findNearestStructureBlock(var1, 15, var2 = var0.getLevel());
        if (var3 == null) {
            GameTestHarnessTestCommand.say(var2, "Couldn't find any structure block within 15 radius", EnumChatFormat.RED);
            return 0;
        }
        TileEntityStructure var4 = (TileEntityStructure)var2.getBlockEntity(var3);
        String var5 = var4.getStructurePath();
        return GameTestHarnessTestCommand.exportTestStructure(var0, var5);
    }

    private static int exportTestStructure(CommandListenerWrapper var0, String var1) {
        Path var2 = Paths.get(GameTestHarnessStructures.testStructuresDir, new String[0]);
        MinecraftKey var3 = new MinecraftKey("minecraft", var1);
        Path var4 = var0.getLevel().getStructureManager().getPathToGeneratedStructure(var3, ".nbt");
        Path var5 = DebugReportNBT.convertStructure(CachedOutput.NO_CACHE, var4, var1, var2);
        if (var5 == null) {
            GameTestHarnessTestCommand.say(var0, "Failed to export " + var4);
            return 1;
        }
        try {
            Files.createDirectories(var5.getParent(), new FileAttribute[0]);
        }
        catch (IOException var6) {
            GameTestHarnessTestCommand.say(var0, "Could not create folder " + var5.getParent());
            var6.printStackTrace();
            return 1;
        }
        GameTestHarnessTestCommand.say(var0, "Exported " + var1 + " to " + var5.toAbsolutePath());
        return 0;
    }

    private static int importTestStructure(CommandListenerWrapper var0, String var1) {
        Path var2 = Paths.get(GameTestHarnessStructures.testStructuresDir, var1 + ".snbt");
        MinecraftKey var3 = new MinecraftKey("minecraft", var1);
        Path var4 = var0.getLevel().getStructureManager().getPathToGeneratedStructure(var3, ".nbt");
        try {
            BufferedReader var5 = Files.newBufferedReader(var2);
            String var6 = IOUtils.toString((Reader)var5);
            Files.createDirectories(var4.getParent(), new FileAttribute[0]);
            try (OutputStream var7 = Files.newOutputStream(var4, new OpenOption[0]);){
                NBTCompressedStreamTools.writeCompressed(GameProfileSerializer.snbtToStructure(var6), var7);
            }
            GameTestHarnessTestCommand.say(var0, "Imported to " + var4.toAbsolutePath());
            return 0;
        }
        catch (CommandSyntaxException | IOException var5) {
            System.err.println("Failed to load structure " + var1);
            var5.printStackTrace();
            return 1;
        }
    }

    private static void say(WorldServer var02, String var1, EnumChatFormat var22) {
        var02.getPlayers(var0 -> true).forEach(var2 -> var2.sendSystemMessage(IChatBaseComponent.literal(var22 + var1)));
    }

    static class a
    implements GameTestHarnessListener {
        private final WorldServer level;
        private final GameTestHarnessCollector tracker;

        public a(WorldServer var0, GameTestHarnessCollector var1) {
            this.level = var0;
            this.tracker = var1;
        }

        @Override
        public void testStructureLoaded(GameTestHarnessInfo var0) {
        }

        @Override
        public void testPassed(GameTestHarnessInfo var0) {
            GameTestHarnessTestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testFailed(GameTestHarnessInfo var0) {
            GameTestHarnessTestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }
    }
}

