/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class OrePlacements {
    public static final ResourceKey<PlacedFeature> ORE_MAGMA = PlacementUtils.createKey("ore_magma");
    public static final ResourceKey<PlacedFeature> ORE_SOUL_SAND = PlacementUtils.createKey("ore_soul_sand");
    public static final ResourceKey<PlacedFeature> ORE_GOLD_DELTAS = PlacementUtils.createKey("ore_gold_deltas");
    public static final ResourceKey<PlacedFeature> ORE_QUARTZ_DELTAS = PlacementUtils.createKey("ore_quartz_deltas");
    public static final ResourceKey<PlacedFeature> ORE_GOLD_NETHER = PlacementUtils.createKey("ore_gold_nether");
    public static final ResourceKey<PlacedFeature> ORE_QUARTZ_NETHER = PlacementUtils.createKey("ore_quartz_nether");
    public static final ResourceKey<PlacedFeature> ORE_GRAVEL_NETHER = PlacementUtils.createKey("ore_gravel_nether");
    public static final ResourceKey<PlacedFeature> ORE_BLACKSTONE = PlacementUtils.createKey("ore_blackstone");
    public static final ResourceKey<PlacedFeature> ORE_DIRT = PlacementUtils.createKey("ore_dirt");
    public static final ResourceKey<PlacedFeature> ORE_GRAVEL = PlacementUtils.createKey("ore_gravel");
    public static final ResourceKey<PlacedFeature> ORE_GRANITE_UPPER = PlacementUtils.createKey("ore_granite_upper");
    public static final ResourceKey<PlacedFeature> ORE_GRANITE_LOWER = PlacementUtils.createKey("ore_granite_lower");
    public static final ResourceKey<PlacedFeature> ORE_DIORITE_UPPER = PlacementUtils.createKey("ore_diorite_upper");
    public static final ResourceKey<PlacedFeature> ORE_DIORITE_LOWER = PlacementUtils.createKey("ore_diorite_lower");
    public static final ResourceKey<PlacedFeature> ORE_ANDESITE_UPPER = PlacementUtils.createKey("ore_andesite_upper");
    public static final ResourceKey<PlacedFeature> ORE_ANDESITE_LOWER = PlacementUtils.createKey("ore_andesite_lower");
    public static final ResourceKey<PlacedFeature> ORE_TUFF = PlacementUtils.createKey("ore_tuff");
    public static final ResourceKey<PlacedFeature> ORE_COAL_UPPER = PlacementUtils.createKey("ore_coal_upper");
    public static final ResourceKey<PlacedFeature> ORE_COAL_LOWER = PlacementUtils.createKey("ore_coal_lower");
    public static final ResourceKey<PlacedFeature> ORE_IRON_UPPER = PlacementUtils.createKey("ore_iron_upper");
    public static final ResourceKey<PlacedFeature> ORE_IRON_MIDDLE = PlacementUtils.createKey("ore_iron_middle");
    public static final ResourceKey<PlacedFeature> ORE_IRON_SMALL = PlacementUtils.createKey("ore_iron_small");
    public static final ResourceKey<PlacedFeature> ORE_GOLD_EXTRA = PlacementUtils.createKey("ore_gold_extra");
    public static final ResourceKey<PlacedFeature> ORE_GOLD = PlacementUtils.createKey("ore_gold");
    public static final ResourceKey<PlacedFeature> ORE_GOLD_LOWER = PlacementUtils.createKey("ore_gold_lower");
    public static final ResourceKey<PlacedFeature> ORE_REDSTONE = PlacementUtils.createKey("ore_redstone");
    public static final ResourceKey<PlacedFeature> ORE_REDSTONE_LOWER = PlacementUtils.createKey("ore_redstone_lower");
    public static final ResourceKey<PlacedFeature> ORE_DIAMOND = PlacementUtils.createKey("ore_diamond");
    public static final ResourceKey<PlacedFeature> ORE_DIAMOND_LARGE = PlacementUtils.createKey("ore_diamond_large");
    public static final ResourceKey<PlacedFeature> ORE_DIAMOND_BURIED = PlacementUtils.createKey("ore_diamond_buried");
    public static final ResourceKey<PlacedFeature> ORE_LAPIS = PlacementUtils.createKey("ore_lapis");
    public static final ResourceKey<PlacedFeature> ORE_LAPIS_BURIED = PlacementUtils.createKey("ore_lapis_buried");
    public static final ResourceKey<PlacedFeature> ORE_INFESTED = PlacementUtils.createKey("ore_infested");
    public static final ResourceKey<PlacedFeature> ORE_EMERALD = PlacementUtils.createKey("ore_emerald");
    public static final ResourceKey<PlacedFeature> ORE_ANCIENT_DEBRIS_LARGE = PlacementUtils.createKey("ore_ancient_debris_large");
    public static final ResourceKey<PlacedFeature> ORE_ANCIENT_DEBRIS_SMALL = PlacementUtils.createKey("ore_debris_small");
    public static final ResourceKey<PlacedFeature> ORE_COPPER = PlacementUtils.createKey("ore_copper");
    public static final ResourceKey<PlacedFeature> ORE_COPPER_LARGE = PlacementUtils.createKey("ore_copper_large");
    public static final ResourceKey<PlacedFeature> ORE_CLAY = PlacementUtils.createKey("ore_clay");

    private static List<PlacementModifier> orePlacement(PlacementModifier var0, PlacementModifier var1) {
        return List.of(var0, InSquarePlacement.spread(), var1, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int var0, PlacementModifier var1) {
        return OrePlacements.orePlacement(CountPlacement.of(var0), var1);
    }

    private static List<PlacementModifier> rareOrePlacement(int var0, PlacementModifier var1) {
        return OrePlacements.orePlacement(RarityFilter.onAverageOnceEvery(var0), var1);
    }

    public static void bootstrap(BootstapContext<PlacedFeature> var0) {
        HolderGetter<WorldGenFeatureConfigured<?, ?>> var1 = var0.lookup(Registries.CONFIGURED_FEATURE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var2 = var1.getOrThrow(OreFeatures.ORE_MAGMA);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var3 = var1.getOrThrow(OreFeatures.ORE_SOUL_SAND);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var4 = var1.getOrThrow(OreFeatures.ORE_NETHER_GOLD);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var5 = var1.getOrThrow(OreFeatures.ORE_QUARTZ);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var6 = var1.getOrThrow(OreFeatures.ORE_GRAVEL_NETHER);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var7 = var1.getOrThrow(OreFeatures.ORE_BLACKSTONE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var8 = var1.getOrThrow(OreFeatures.ORE_DIRT);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var9 = var1.getOrThrow(OreFeatures.ORE_GRAVEL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var10 = var1.getOrThrow(OreFeatures.ORE_GRANITE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var11 = var1.getOrThrow(OreFeatures.ORE_DIORITE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var12 = var1.getOrThrow(OreFeatures.ORE_ANDESITE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var13 = var1.getOrThrow(OreFeatures.ORE_TUFF);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var14 = var1.getOrThrow(OreFeatures.ORE_COAL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var15 = var1.getOrThrow(OreFeatures.ORE_COAL_BURIED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var16 = var1.getOrThrow(OreFeatures.ORE_IRON);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var17 = var1.getOrThrow(OreFeatures.ORE_IRON_SMALL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var18 = var1.getOrThrow(OreFeatures.ORE_GOLD);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var19 = var1.getOrThrow(OreFeatures.ORE_GOLD_BURIED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var20 = var1.getOrThrow(OreFeatures.ORE_REDSTONE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var21 = var1.getOrThrow(OreFeatures.ORE_DIAMOND_SMALL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var22 = var1.getOrThrow(OreFeatures.ORE_DIAMOND_LARGE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var23 = var1.getOrThrow(OreFeatures.ORE_DIAMOND_BURIED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var24 = var1.getOrThrow(OreFeatures.ORE_LAPIS);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var25 = var1.getOrThrow(OreFeatures.ORE_LAPIS_BURIED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var26 = var1.getOrThrow(OreFeatures.ORE_INFESTED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var27 = var1.getOrThrow(OreFeatures.ORE_EMERALD);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var28 = var1.getOrThrow(OreFeatures.ORE_ANCIENT_DEBRIS_LARGE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var29 = var1.getOrThrow(OreFeatures.ORE_ANCIENT_DEBRIS_SMALL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var30 = var1.getOrThrow(OreFeatures.ORE_COPPPER_SMALL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var31 = var1.getOrThrow(OreFeatures.ORE_COPPER_LARGE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var32 = var1.getOrThrow(OreFeatures.ORE_CLAY);
        PlacementUtils.register(var0, ORE_MAGMA, var2, OrePlacements.commonOrePlacement(4, HeightRangePlacement.uniform(VerticalAnchor.absolute(27), VerticalAnchor.absolute(36))));
        PlacementUtils.register(var0, ORE_SOUL_SAND, var3, OrePlacements.commonOrePlacement(12, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(31))));
        PlacementUtils.register(var0, ORE_GOLD_DELTAS, var4, OrePlacements.commonOrePlacement(20, PlacementUtils.RANGE_10_10));
        PlacementUtils.register(var0, ORE_QUARTZ_DELTAS, var5, OrePlacements.commonOrePlacement(32, PlacementUtils.RANGE_10_10));
        PlacementUtils.register(var0, ORE_GOLD_NETHER, var4, OrePlacements.commonOrePlacement(10, PlacementUtils.RANGE_10_10));
        PlacementUtils.register(var0, ORE_QUARTZ_NETHER, var5, OrePlacements.commonOrePlacement(16, PlacementUtils.RANGE_10_10));
        PlacementUtils.register(var0, ORE_GRAVEL_NETHER, var6, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.absolute(5), VerticalAnchor.absolute(41))));
        PlacementUtils.register(var0, ORE_BLACKSTONE, var7, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.absolute(5), VerticalAnchor.absolute(31))));
        PlacementUtils.register(var0, ORE_DIRT, var8, OrePlacements.commonOrePlacement(7, HeightRangePlacement.uniform(VerticalAnchor.absolute(0), VerticalAnchor.absolute(160))));
        PlacementUtils.register(var0, ORE_GRAVEL, var9, OrePlacements.commonOrePlacement(14, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.top())));
        PlacementUtils.register(var0, ORE_GRANITE_UPPER, var10, OrePlacements.rareOrePlacement(6, HeightRangePlacement.uniform(VerticalAnchor.absolute(64), VerticalAnchor.absolute(128))));
        PlacementUtils.register(var0, ORE_GRANITE_LOWER, var10, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.absolute(0), VerticalAnchor.absolute(60))));
        PlacementUtils.register(var0, ORE_DIORITE_UPPER, var11, OrePlacements.rareOrePlacement(6, HeightRangePlacement.uniform(VerticalAnchor.absolute(64), VerticalAnchor.absolute(128))));
        PlacementUtils.register(var0, ORE_DIORITE_LOWER, var11, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.absolute(0), VerticalAnchor.absolute(60))));
        PlacementUtils.register(var0, ORE_ANDESITE_UPPER, var12, OrePlacements.rareOrePlacement(6, HeightRangePlacement.uniform(VerticalAnchor.absolute(64), VerticalAnchor.absolute(128))));
        PlacementUtils.register(var0, ORE_ANDESITE_LOWER, var12, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.absolute(0), VerticalAnchor.absolute(60))));
        PlacementUtils.register(var0, ORE_TUFF, var13, OrePlacements.commonOrePlacement(2, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(0))));
        PlacementUtils.register(var0, ORE_COAL_UPPER, var14, OrePlacements.commonOrePlacement(30, HeightRangePlacement.uniform(VerticalAnchor.absolute(136), VerticalAnchor.top())));
        PlacementUtils.register(var0, ORE_COAL_LOWER, var15, OrePlacements.commonOrePlacement(20, HeightRangePlacement.triangle(VerticalAnchor.absolute(0), VerticalAnchor.absolute(192))));
        PlacementUtils.register(var0, ORE_IRON_UPPER, var16, OrePlacements.commonOrePlacement(90, HeightRangePlacement.triangle(VerticalAnchor.absolute(80), VerticalAnchor.absolute(384))));
        PlacementUtils.register(var0, ORE_IRON_MIDDLE, var16, OrePlacements.commonOrePlacement(10, HeightRangePlacement.triangle(VerticalAnchor.absolute(-24), VerticalAnchor.absolute(56))));
        PlacementUtils.register(var0, ORE_IRON_SMALL, var17, OrePlacements.commonOrePlacement(10, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(72))));
        PlacementUtils.register(var0, ORE_GOLD_EXTRA, var18, OrePlacements.commonOrePlacement(50, HeightRangePlacement.uniform(VerticalAnchor.absolute(32), VerticalAnchor.absolute(256))));
        PlacementUtils.register(var0, ORE_GOLD, var19, OrePlacements.commonOrePlacement(4, HeightRangePlacement.triangle(VerticalAnchor.absolute(-64), VerticalAnchor.absolute(32))));
        PlacementUtils.register(var0, ORE_GOLD_LOWER, var19, OrePlacements.orePlacement(CountPlacement.of(UniformInt.of(0, 1)), HeightRangePlacement.uniform(VerticalAnchor.absolute(-64), VerticalAnchor.absolute(-48))));
        PlacementUtils.register(var0, ORE_REDSTONE, var20, OrePlacements.commonOrePlacement(4, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(15))));
        PlacementUtils.register(var0, ORE_REDSTONE_LOWER, var20, OrePlacements.commonOrePlacement(8, HeightRangePlacement.triangle(VerticalAnchor.aboveBottom(-32), VerticalAnchor.aboveBottom(32))));
        PlacementUtils.register(var0, ORE_DIAMOND, var21, OrePlacements.commonOrePlacement(7, HeightRangePlacement.triangle(VerticalAnchor.aboveBottom(-80), VerticalAnchor.aboveBottom(80))));
        PlacementUtils.register(var0, ORE_DIAMOND_LARGE, var22, OrePlacements.rareOrePlacement(9, HeightRangePlacement.triangle(VerticalAnchor.aboveBottom(-80), VerticalAnchor.aboveBottom(80))));
        PlacementUtils.register(var0, ORE_DIAMOND_BURIED, var23, OrePlacements.commonOrePlacement(4, HeightRangePlacement.triangle(VerticalAnchor.aboveBottom(-80), VerticalAnchor.aboveBottom(80))));
        PlacementUtils.register(var0, ORE_LAPIS, var24, OrePlacements.commonOrePlacement(2, HeightRangePlacement.triangle(VerticalAnchor.absolute(-32), VerticalAnchor.absolute(32))));
        PlacementUtils.register(var0, ORE_LAPIS_BURIED, var25, OrePlacements.commonOrePlacement(4, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(64))));
        PlacementUtils.register(var0, ORE_INFESTED, var26, OrePlacements.commonOrePlacement(14, HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(63))));
        PlacementUtils.register(var0, ORE_EMERALD, var27, OrePlacements.commonOrePlacement(100, HeightRangePlacement.triangle(VerticalAnchor.absolute(-16), VerticalAnchor.absolute(480))));
        PlacementUtils.register(var0, ORE_ANCIENT_DEBRIS_LARGE, var28, InSquarePlacement.spread(), HeightRangePlacement.triangle(VerticalAnchor.absolute(8), VerticalAnchor.absolute(24)), BiomeFilter.biome());
        PlacementUtils.register(var0, ORE_ANCIENT_DEBRIS_SMALL, var29, InSquarePlacement.spread(), PlacementUtils.RANGE_8_8, BiomeFilter.biome());
        PlacementUtils.register(var0, ORE_COPPER, var30, OrePlacements.commonOrePlacement(16, HeightRangePlacement.triangle(VerticalAnchor.absolute(-16), VerticalAnchor.absolute(112))));
        PlacementUtils.register(var0, ORE_COPPER_LARGE, var31, OrePlacements.commonOrePlacement(16, HeightRangePlacement.triangle(VerticalAnchor.absolute(-16), VerticalAnchor.absolute(112))));
        PlacementUtils.register(var0, ORE_CLAY, var32, OrePlacements.commonOrePlacement(46, PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT));
    }
}

