/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    @Nullable
    private static final Path DUMP_SNBT_TO = null;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final Iterable<Path> inputFolders;
    private final List<a> filters = Lists.newArrayList();

    public SnbtToNbt(PackOutput var0, Iterable<Path> var1) {
        this.output = var0;
        this.inputFolders = var1;
    }

    public SnbtToNbt addFilter(a var0) {
        this.filters.add(var0);
        return this;
    }

    private NBTTagCompound applyFilters(String var0, NBTTagCompound var1) {
        NBTTagCompound var2 = var1;
        for (a var4 : this.filters) {
            var2 = var4.apply(var0, var2);
        }
        return var2;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput var02) {
        Path var1 = this.output.getOutputFolder();
        ArrayList var2 = Lists.newArrayList();
        for (Path var4 : this.inputFolders) {
            var2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> var32 = Files.walk(var4, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])var32.filter(var0 -> var0.toString().endsWith(".snbt")).map(var3 -> CompletableFuture.runAsync(() -> {
                            c var4 = this.readStructure((Path)var3, this.getName(var4, (Path)var3));
                            this.storeStructureIfChanged(var02, var4, var1);
                        }, SystemUtils.backgroundExecutor())).toArray(CompletableFuture[]::new));
                        if (var32 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (var32 != null) {
                                try {
                                    var32.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception var33) {
                            throw new RuntimeException("Failed to read structure input directory, aborting", var33);
                        }
                    }
                    var32.close();
                }
                return completableFuture;
            }, SystemUtils.backgroundExecutor()).thenCompose(var0 -> var0));
        }
        return SystemUtils.sequenceFailFast(var2);
    }

    @Override
    public final String getName() {
        return "SNBT -> NBT";
    }

    private String getName(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".snbt".length());
    }

    private c readStructure(Path var0, String var1) {
        c c2;
        block8: {
            BufferedReader var2 = Files.newBufferedReader(var0);
            try {
                String var3 = IOUtils.toString((Reader)var2);
                NBTTagCompound var4 = this.applyFilters(var1, GameProfileSerializer.snbtToStructure(var3));
                ByteArrayOutputStream var5 = new ByteArrayOutputStream();
                HashingOutputStream var6 = new HashingOutputStream(Hashing.sha1(), (OutputStream)var5);
                NBTCompressedStreamTools.writeCompressed(var4, (OutputStream)var6);
                byte[] var7 = var5.toByteArray();
                HashCode var8 = var6.hash();
                String var9 = DUMP_SNBT_TO != null ? GameProfileSerializer.structureToSnbt(var4) : null;
                c2 = new c(var1, var7, var9, var8);
                if (var2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable var22) {
                    throw new b(var0, var22);
                }
            }
            var2.close();
        }
        return c2;
    }

    private void storeStructureIfChanged(CachedOutput var0, c var1, Path var2) {
        Path var3;
        if (var1.snbtPayload != null) {
            var3 = DUMP_SNBT_TO.resolve(var1.name + ".snbt");
            try {
                DebugReportNBT.writeSnbt(CachedOutput.NO_CACHE, var3, var1.snbtPayload);
            }
            catch (IOException var4) {
                LOGGER.error("Couldn't write structure SNBT {} at {}", new Object[]{var1.name, var3, var4});
            }
        }
        var3 = var2.resolve(var1.name + ".nbt");
        try {
            var0.writeIfNeeded(var3, var1.payload, var1.hash);
        }
        catch (IOException var4) {
            LOGGER.error("Couldn't write structure {} at {}", new Object[]{var1.name, var3, var4});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    static final class c
    extends Record {
        final String name;
        final byte[] payload;
        @Nullable
        final String snbtPayload;
        final HashCode hash;

        c(String var0, byte[] var1, @Nullable String var2, HashCode var3) {
            this.name = var0;
            this.payload = var1;
            this.snbtPayload = var2;
            this.hash = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "name", "payload", "snbtPayload", "hash"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "name", "payload", "snbtPayload", "hash"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "name", "payload", "snbtPayload", "hash"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        public byte[] payload() {
            return this.payload;
        }

        @Nullable
        public String snbtPayload() {
            return this.snbtPayload;
        }

        public HashCode hash() {
            return this.hash;
        }
    }

    static class b
    extends RuntimeException {
        public b(Path var0, Throwable var1) {
            super(var0.toAbsolutePath().toString(), var1);
        }
    }
}

