/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.scores.ScoreboardScore;

public class ArgumentMathOperation
implements ArgumentType<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType ERROR_INVALID_OPERATION = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType ERROR_DIVIDE_BY_ZERO = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("arguments.operation.div0"));

    public static ArgumentMathOperation operation() {
        return new ArgumentMathOperation();
    }

    public static a getOperation(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (a)var0.getArgument(var1, a.class);
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead()) {
            int var1 = var0.getCursor();
            while (var0.canRead() && var0.peek() != ' ') {
                var0.skip();
            }
            return ArgumentMathOperation.getOperation(var0.getString().substring(var1, var0.getCursor()));
        }
        throw ERROR_INVALID_OPERATION.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static a getOperation(String var02) throws CommandSyntaxException {
        if (var02.equals("><")) {
            return (var0, var1) -> {
                int var2 = var0.getScore();
                var0.setScore(var1.getScore());
                var1.setScore(var2);
            };
        }
        return ArgumentMathOperation.getSimpleOperation(var02);
    }

    private static b getSimpleOperation(String var02) throws CommandSyntaxException {
        switch (var02) {
            case "=": {
                return (var0, var1) -> var1;
            }
            case "+=": {
                return (var0, var1) -> var0 + var1;
            }
            case "-=": {
                return (var0, var1) -> var0 - var1;
            }
            case "*=": {
                return (var0, var1) -> var0 * var1;
            }
            case "/=": {
                return (var0, var1) -> {
                    if (var1 == 0) {
                        throw ERROR_DIVIDE_BY_ZERO.create();
                    }
                    return MathHelper.floorDiv(var0, var1);
                };
            }
            case "%=": {
                return (var0, var1) -> {
                    if (var1 == 0) {
                        throw ERROR_DIVIDE_BY_ZERO.create();
                    }
                    return MathHelper.positiveModulo(var0, var1);
                };
            }
            case "<": {
                return Math::min;
            }
            case ">": {
                return Math::max;
            }
        }
        throw ERROR_INVALID_OPERATION.create();
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface a {
        public void apply(ScoreboardScore var1, ScoreboardScore var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b
    extends a {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(ScoreboardScore var0, ScoreboardScore var1) throws CommandSyntaxException {
            var0.setScore(this.apply(var0.getScore(), var1.getScore()));
        }
    }
}

