/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.phys.Vec3D;

public class LighthingBoltPredicate
implements EntitySubPredicate {
    private static final String BLOCKS_SET_ON_FIRE_KEY = "blocks_set_on_fire";
    private static final String ENTITY_STRUCK_KEY = "entity_struck";
    private final CriterionConditionValue.IntegerRange blocksSetOnFire;
    private final CriterionConditionEntity entityStruck;

    private LighthingBoltPredicate(CriterionConditionValue.IntegerRange var0, CriterionConditionEntity var1) {
        this.blocksSetOnFire = var0;
        this.entityStruck = var1;
    }

    public static LighthingBoltPredicate blockSetOnFire(CriterionConditionValue.IntegerRange var0) {
        return new LighthingBoltPredicate(var0, CriterionConditionEntity.ANY);
    }

    public static LighthingBoltPredicate fromJson(JsonObject var0) {
        return new LighthingBoltPredicate(CriterionConditionValue.IntegerRange.fromJson(var0.get(BLOCKS_SET_ON_FIRE_KEY)), CriterionConditionEntity.fromJson(var0.get(ENTITY_STRUCK_KEY)));
    }

    @Override
    public JsonObject serializeCustomData() {
        JsonObject var0 = new JsonObject();
        var0.add(BLOCKS_SET_ON_FIRE_KEY, this.blocksSetOnFire.serializeToJson());
        var0.add(ENTITY_STRUCK_KEY, this.entityStruck.serializeToJson());
        return var0;
    }

    @Override
    public EntitySubPredicate.a type() {
        return EntitySubPredicate.b.LIGHTNING;
    }

    @Override
    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var22) {
        if (!(var0 instanceof EntityLightning)) {
            return false;
        }
        EntityLightning var3 = (EntityLightning)var0;
        return this.blocksSetOnFire.matches(var3.getBlocksSetOnFire()) && (this.entityStruck == CriterionConditionEntity.ANY || var3.getHitEntities().anyMatch(var2 -> this.entityStruck.matches(var1, var22, (Entity)var2)));
    }
}

