/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;

public class ItemUsedOnLocationTrigger
extends CriterionTriggerAbstract<a> {
    final MinecraftKey id;

    public ItemUsedOnLocationTrigger(MinecraftKey var0) {
        this.id = var0;
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public a createInstance(JsonObject var0, ContextAwarePredicate var1, LootDeserializationContext var2) {
        ContextAwarePredicate var3 = ContextAwarePredicate.fromElement("location", var2, var0.get("location"), LootContextParameterSets.ADVANCEMENT_LOCATION);
        if (var3 == null) {
            throw new JsonParseException("Failed to parse 'location' field");
        }
        return new a(this.id, var1, var3);
    }

    public void trigger(EntityPlayer var0, BlockPosition var12, ItemStack var2) {
        WorldServer var3 = var0.serverLevel();
        IBlockData var4 = var3.getBlockState(var12);
        LootParams var5 = new LootParams.a(var3).withParameter(LootContextParameters.ORIGIN, var12.getCenter()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.BLOCK_STATE, var4).withParameter(LootContextParameters.TOOL, var2).create(LootContextParameterSets.ADVANCEMENT_LOCATION);
        LootTableInfo var6 = new LootTableInfo.Builder(var5).create(null);
        this.trigger(var0, var1 -> var1.matches(var6));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final ContextAwarePredicate location;

        public a(MinecraftKey var0, ContextAwarePredicate var1, ContextAwarePredicate var2) {
            super(var0, var1);
            this.location = var2;
        }

        public static a placedBlock(Block var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create(LootItemConditionBlockStateProperty.hasBlockStateProperties(var0).build());
            return new a(CriterionTriggers.PLACED_BLOCK.id, ContextAwarePredicate.ANY, var1);
        }

        public static a placedBlock(LootItemCondition.a ... var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create((LootItemCondition[])Arrays.stream(var0).map(LootItemCondition.a::build).toArray(LootItemCondition[]::new));
            return new a(CriterionTriggers.PLACED_BLOCK.id, ContextAwarePredicate.ANY, var1);
        }

        private static a itemUsedOnLocation(CriterionConditionLocation.a var0, CriterionConditionItem.a var1, MinecraftKey var2) {
            ContextAwarePredicate var3 = ContextAwarePredicate.create(LootItemConditionLocationCheck.checkLocation(var0).build(), LootItemConditionMatchTool.toolMatches(var1).build());
            return new a(var2, ContextAwarePredicate.ANY, var3);
        }

        public static a itemUsedOnBlock(CriterionConditionLocation.a var0, CriterionConditionItem.a var1) {
            return a.itemUsedOnLocation(var0, var1, CriterionTriggers.ITEM_USED_ON_BLOCK.id);
        }

        public static a allayDropItemOnBlock(CriterionConditionLocation.a var0, CriterionConditionItem.a var1) {
            return a.itemUsedOnLocation(var0, var1, CriterionTriggers.ALLAY_DROP_ITEM_ON_BLOCK.id);
        }

        public boolean matches(LootTableInfo var0) {
            return this.location.matches(var0);
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            var1.add("location", this.location.toJson(var0));
            return var1;
        }
    }
}

