/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public class CriterionTriggerInventoryChanged
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("inventory_changed");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, ContextAwarePredicate var1, LootDeserializationContext var2) {
        JsonObject var3 = ChatDeserializer.getAsJsonObject(var0, "slots", new JsonObject());
        CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.fromJson(var3.get("occupied"));
        CriterionConditionValue.IntegerRange var5 = CriterionConditionValue.IntegerRange.fromJson(var3.get("full"));
        CriterionConditionValue.IntegerRange var6 = CriterionConditionValue.IntegerRange.fromJson(var3.get("empty"));
        CriterionConditionItem[] var7 = CriterionConditionItem.fromJsonArray(var0.get("items"));
        return new a(var1, var4, var5, var6, var7);
    }

    public void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2) {
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        for (int var6 = 0; var6 < var1.getContainerSize(); ++var6) {
            ItemStack var7 = var1.getItem(var6);
            if (var7.isEmpty()) {
                ++var4;
                continue;
            }
            ++var5;
            if (var7.getCount() < var7.getMaxStackSize()) continue;
            ++var3;
        }
        this.trigger(var0, var1, var2, var3, var4, var5);
    }

    private void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2, int var3, int var4, int var52) {
        this.trigger(var0, var5 -> var5.matches(var1, var2, var3, var4, var52));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final CriterionConditionValue.IntegerRange slotsOccupied;
        private final CriterionConditionValue.IntegerRange slotsFull;
        private final CriterionConditionValue.IntegerRange slotsEmpty;
        private final CriterionConditionItem[] predicates;

        public a(ContextAwarePredicate var0, CriterionConditionValue.IntegerRange var1, CriterionConditionValue.IntegerRange var2, CriterionConditionValue.IntegerRange var3, CriterionConditionItem[] var4) {
            super(ID, var0);
            this.slotsOccupied = var1;
            this.slotsFull = var2;
            this.slotsEmpty = var3;
            this.predicates = var4;
        }

        public static a hasItems(CriterionConditionItem ... var0) {
            return new a(ContextAwarePredicate.ANY, CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, var0);
        }

        public static a hasItems(IMaterial ... var0) {
            CriterionConditionItem[] var1 = new CriterionConditionItem[var0.length];
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var1[var2] = new CriterionConditionItem(null, (Set<Item>)ImmutableSet.of((Object)var0[var2].asItem()), CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, CriterionConditionEnchantments.NONE, CriterionConditionEnchantments.NONE, null, CriterionConditionNBT.ANY);
            }
            return a.hasItems(var1);
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var2;
            JsonObject var1 = super.serializeToJson(var0);
            if (!(this.slotsOccupied.isAny() && this.slotsFull.isAny() && this.slotsEmpty.isAny())) {
                var2 = new JsonObject();
                var2.add("occupied", this.slotsOccupied.serializeToJson());
                var2.add("full", this.slotsFull.serializeToJson());
                var2.add("empty", this.slotsEmpty.serializeToJson());
                var1.add("slots", (JsonElement)var2);
            }
            if (this.predicates.length > 0) {
                var2 = new JsonArray();
                for (CriterionConditionItem var6 : this.predicates) {
                    var2.add(var6.serializeToJson());
                }
                var1.add("items", (JsonElement)var2);
            }
            return var1;
        }

        public boolean matches(PlayerInventory var0, ItemStack var12, int var2, int var3, int var4) {
            if (!this.slotsFull.matches(var2)) {
                return false;
            }
            if (!this.slotsEmpty.matches(var3)) {
                return false;
            }
            if (!this.slotsOccupied.matches(var4)) {
                return false;
            }
            int var5 = this.predicates.length;
            if (var5 == 0) {
                return true;
            }
            if (var5 == 1) {
                return !var12.isEmpty() && this.predicates[0].matches(var12);
            }
            ObjectArrayList var6 = new ObjectArrayList((Object[])this.predicates);
            int var7 = var0.getContainerSize();
            for (int var8 = 0; var8 < var7; ++var8) {
                if (var6.isEmpty()) {
                    return true;
                }
                ItemStack var9 = var0.getItem(var8);
                if (var9.isEmpty()) continue;
                var6.removeIf(var1 -> var1.matches(var9));
            }
            return var6.isEmpty();
        }
    }
}

