/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionTriggerEnterBlock
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("enter_block");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, ContextAwarePredicate var12, LootDeserializationContext var2) {
        Block var3 = CriterionTriggerEnterBlock.deserializeBlock(var0);
        CriterionTriggerProperties var4 = CriterionTriggerProperties.fromJson(var0.get("state"));
        if (var3 != null) {
            var4.checkState(var3.getStateDefinition(), var1 -> {
                throw new JsonSyntaxException("Block " + var3 + " has no property " + var1);
            });
        }
        return new a(var12, var3, var4);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject var0) {
        if (var0.has("block")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            return (Block)BuiltInRegistries.BLOCK.getOptional(var1).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + var1 + "'"));
        }
        return null;
    }

    public void trigger(EntityPlayer var0, IBlockData var12) {
        this.trigger(var0, (T var1) -> var1.matches(var12));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, contextAwarePredicate, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final Block block;
        private final CriterionTriggerProperties state;

        public a(ContextAwarePredicate var0, @Nullable Block var1, CriterionTriggerProperties var2) {
            super(ID, var0);
            this.block = var1;
            this.state = var2;
        }

        public static a entersBlock(Block var0) {
            return new a(ContextAwarePredicate.ANY, var0, CriterionTriggerProperties.ANY);
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            if (this.block != null) {
                var1.addProperty("block", BuiltInRegistries.BLOCK.getKey(this.block).toString());
            }
            var1.add("state", this.state.serializeToJson());
            return var1;
        }

        public boolean matches(IBlockData var0) {
            if (this.block != null && !var0.is(this.block)) {
                return false;
            }
            return this.state.matches(var0);
        }
    }
}

