/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionDamageSource {
    public static final CriterionConditionDamageSource ANY = a.damageType().build();
    private final List<TagPredicate<DamageType>> tags;
    private final CriterionConditionEntity directEntity;
    private final CriterionConditionEntity sourceEntity;

    public CriterionConditionDamageSource(List<TagPredicate<DamageType>> var0, CriterionConditionEntity var1, CriterionConditionEntity var2) {
        this.tags = var0;
        this.directEntity = var1;
        this.sourceEntity = var2;
    }

    public boolean matches(EntityPlayer var0, DamageSource var1) {
        return this.matches(var0.serverLevel(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, Vec3D var1, DamageSource var2) {
        if (this == ANY) {
            return true;
        }
        for (TagPredicate<DamageType> var4 : this.tags) {
            if (var4.matches(var2.typeHolder())) continue;
            return false;
        }
        if (!this.directEntity.matches(var0, var1, var2.getDirectEntity())) {
            return false;
        }
        return this.sourceEntity.matches(var0, var1, var2.getEntity());
    }

    public static CriterionConditionDamageSource fromJson(@Nullable JsonElement var0) {
        CriterionConditionEntity var52;
        List<TagPredicate<DamageType>> var3;
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "damage type");
        JsonArray var2 = ChatDeserializer.getAsJsonArray(var1, "tags", null);
        if (var2 != null) {
            var3 = new ArrayList(var2.size());
            for (CriterionConditionEntity var52 : var2) {
                var3.add(TagPredicate.fromJson((JsonElement)var52, Registries.DAMAGE_TYPE));
            }
        } else {
            var3 = List.of();
        }
        CriterionConditionEntity var4 = CriterionConditionEntity.fromJson(var1.get("direct_entity"));
        var52 = CriterionConditionEntity.fromJson(var1.get("source_entity"));
        return new CriterionConditionDamageSource(var3, var4, var52);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (!this.tags.isEmpty()) {
            JsonArray var1 = new JsonArray(this.tags.size());
            for (int var2 = 0; var2 < this.tags.size(); ++var2) {
                var1.add(this.tags.get(var2).serializeToJson());
            }
            var0.add("tags", (JsonElement)var1);
        }
        var0.add("direct_entity", this.directEntity.serializeToJson());
        var0.add("source_entity", this.sourceEntity.serializeToJson());
        return var0;
    }

    public static class a {
        private final ImmutableList.Builder<TagPredicate<DamageType>> tags = ImmutableList.builder();
        private CriterionConditionEntity directEntity = CriterionConditionEntity.ANY;
        private CriterionConditionEntity sourceEntity = CriterionConditionEntity.ANY;

        public static a damageType() {
            return new a();
        }

        public a tag(TagPredicate<DamageType> var0) {
            this.tags.add(var0);
            return this;
        }

        public a direct(CriterionConditionEntity var0) {
            this.directEntity = var0;
            return this;
        }

        public a direct(CriterionConditionEntity.a var0) {
            this.directEntity = var0.build();
            return this;
        }

        public a source(CriterionConditionEntity var0) {
            this.sourceEntity = var0;
            return this;
        }

        public a source(CriterionConditionEntity.a var0) {
            this.sourceEntity = var0.build();
            return this;
        }

        public CriterionConditionDamageSource build() {
            return new CriterionConditionDamageSource((List<TagPredicate<DamageType>>)this.tags.build(), this.directEntity, this.sourceEntity);
        }
    }
}

